/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat$FieldType;
import com.google.protobuf.WireFormat$Utf8Validation;

public final class WireFormat {
    static final int FIXED32_SIZE = 4;
    static final int FIXED64_SIZE = 8;
    static final int MAX_VARINT32_SIZE = 5;
    static final int MAX_VARINT64_SIZE = 10;
    static final int MAX_VARINT_SIZE = 10;
    public static final int WIRETYPE_VARINT = 0;
    public static final int WIRETYPE_FIXED64 = 1;
    public static final int WIRETYPE_LENGTH_DELIMITED = 2;
    public static final int WIRETYPE_START_GROUP = 3;
    public static final int WIRETYPE_END_GROUP = 4;
    public static final int WIRETYPE_FIXED32 = 5;
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;
    static final int MESSAGE_SET_ITEM = 1;
    static final int MESSAGE_SET_TYPE_ID = 2;
    static final int MESSAGE_SET_MESSAGE = 3;
    static final int MESSAGE_SET_ITEM_TAG = WireFormat.makeTag(1, 3);
    static final int MESSAGE_SET_ITEM_END_TAG = WireFormat.makeTag(1, 4);
    static final int MESSAGE_SET_TYPE_ID_TAG = WireFormat.makeTag(2, 0);
    static final int MESSAGE_SET_MESSAGE_TAG = WireFormat.makeTag(3, 2);

    private WireFormat() {
    }

    public static int getTagWireType(int n) {
        return n & 7;
    }

    public static int getTagFieldNumber(int n) {
        return n >>> 3;
    }

    static int makeTag(int n, int n2) {
        return n << 3 | n2;
    }

    static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat$FieldType wireFormat$FieldType, WireFormat$Utf8Validation wireFormat$Utf8Validation) {
        switch (wireFormat$FieldType) {
            case DOUBLE: {
                return codedInputStream.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(codedInputStream.readFloat());
            }
            case INT64: {
                return codedInputStream.readInt64();
            }
            case UINT64: {
                return codedInputStream.readUInt64();
            }
            case INT32: {
                return codedInputStream.readInt32();
            }
            case FIXED64: {
                return codedInputStream.readFixed64();
            }
            case FIXED32: {
                return codedInputStream.readFixed32();
            }
            case BOOL: {
                return codedInputStream.readBool();
            }
            case BYTES: {
                return codedInputStream.readBytes();
            }
            case UINT32: {
                return codedInputStream.readUInt32();
            }
            case SFIXED32: {
                return codedInputStream.readSFixed32();
            }
            case SFIXED64: {
                return codedInputStream.readSFixed64();
            }
            case SINT32: {
                return codedInputStream.readSInt32();
            }
            case SINT64: {
                return codedInputStream.readSInt64();
            }
            case STRING: {
                return wireFormat$Utf8Validation.readString(codedInputStream);
            }
            case GROUP: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case MESSAGE: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case ENUM: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }
}

