/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public abstract class RGBComposite
implements Composite {
    protected float extraAlpha;

    public RGBComposite() {
        this(1.0f);
    }

    public RGBComposite(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("RGBComposite: alpha must be between 0 and 1");
        }
        this.extraAlpha = f2;
    }

    public float getAlpha() {
        return this.extraAlpha;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.extraAlpha);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RGBComposite)) {
            return false;
        }
        RGBComposite rGBComposite = (RGBComposite)object;
        return this.extraAlpha == rGBComposite.extraAlpha;
    }

    public abstract CompositeContext createContext(ColorModel var1, ColorModel var2, RenderingHints var3);
}

