/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class CircleFilter
extends TransformFilter {
    private float radius = 10.0f;
    private float height = 20.0f;
    private float angle = 0.0f;
    private float spreadAngle = (float)Math.PI;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float icentreX;
    private float icentreY;
    private float iWidth;
    private float iHeight;

    public CircleFilter() {
        this.setEdgeAction(0);
    }

    public void setHeight(float f2) {
        this.height = f2;
    }

    public float getHeight() {
        return this.height;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setSpreadAngle(float f2) {
        this.spreadAngle = f2;
    }

    public float getSpreadAngle() {
        return this.spreadAngle;
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.iWidth = bufferedImage.getWidth();
        this.iHeight = bufferedImage.getHeight();
        this.icentreX = this.iWidth * this.centreX;
        this.icentreY = this.iHeight * this.centreY;
        this.iWidth -= 1.0f;
        return super.filter(bufferedImage, bufferedImage2);
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = (float)n - this.icentreX;
        float f3 = (float)n2 - this.icentreY;
        float f4 = (float)Math.atan2(-f3, -f2) + this.angle;
        float f5 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        f4 = ImageMath.mod(f4, (float)Math.PI * 2);
        fArray[0] = this.iWidth * f4 / (this.spreadAngle + 1.0E-5f);
        fArray[1] = this.iHeight * (1.0f - (f5 - this.radius) / (this.height + 1.0E-5f));
    }

    public String toString() {
        return "Distort/Circle...";
    }
}

