/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PointFilter;
import java.awt.image.BufferedImage;
import java.util.Random;

public class DissolveFilter
extends PointFilter {
    private float density = 1.0f;
    private float softness = 0.0f;
    private float minDensity;
    private float maxDensity;
    private Random randomNumbers;

    public void setDensity(float f2) {
        this.density = f2;
    }

    public float getDensity() {
        return this.density;
    }

    public void setSoftness(float f2) {
        this.softness = f2;
    }

    public float getSoftness() {
        return this.softness;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f2 = (1.0f - this.density) * (1.0f + this.softness);
        this.minDensity = f2 - this.softness;
        this.maxDensity = f2;
        this.randomNumbers = new Random(0L);
        return super.filter(bufferedImage, bufferedImage2);
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xFF;
        float f2 = this.randomNumbers.nextFloat();
        float f3 = ImageMath.smoothStep(this.minDensity, this.maxDensity, f2);
        return (int)((float)n4 * f3) << 24 | n3 & 0xFFFFFF;
    }

    public String toString() {
        return "Stylize/Dissolve...";
    }
}

