/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.CellularFunction2D;
import com.jhlabs.math.FBM;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;
import com.jhlabs.math.RidgedFBM;
import com.jhlabs.math.SCNoise;
import com.jhlabs.math.VLNoise;
import java.awt.image.BufferedImage;
import java.util.Random;

public class FBMFilter
extends PointFilter
implements Cloneable {
    public static final int NOISE = 0;
    public static final int RIDGED = 1;
    public static final int VLNOISE = 2;
    public static final int SCNOISE = 3;
    public static final int CELLULAR = 4;
    private float scale = 32.0f;
    private float stretch = 1.0f;
    private float angle = 0.0f;
    private float amount = 1.0f;
    private float H = 1.0f;
    private float octaves = 4.0f;
    private float lacunarity = 2.0f;
    private float gain = 0.5f;
    private float bias = 0.5f;
    private int operation;
    private float m00 = 1.0f;
    private float m01 = 0.0f;
    private float m10 = 0.0f;
    private float m11 = 1.0f;
    private float min;
    private float max;
    private Colormap colormap = new Gradient();
    private boolean ridged;
    private FBM fBm;
    protected Random random = new Random();
    private int basisType = 0;
    private Function2D basis;

    public FBMFilter() {
        this.setBasisType(0);
    }

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f2) {
        this.stretch = f2;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float f2) {
        this.angle = f2;
        float f3 = (float)Math.cos(this.angle);
        float f4 = (float)Math.sin(this.angle);
        this.m00 = f3;
        this.m01 = f4;
        this.m10 = -f4;
        this.m11 = f3;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setOctaves(float f2) {
        this.octaves = f2;
    }

    public float getOctaves() {
        return this.octaves;
    }

    public void setH(float f2) {
        this.H = f2;
    }

    public float getH() {
        return this.H;
    }

    public void setLacunarity(float f2) {
        this.lacunarity = f2;
    }

    public float getLacunarity() {
        return this.lacunarity;
    }

    public void setGain(float f2) {
        this.gain = f2;
    }

    public float getGain() {
        return this.gain;
    }

    public void setBias(float f2) {
        this.bias = f2;
    }

    public float getBias() {
        return this.bias;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setBasisType(int n) {
        this.basisType = n;
        switch (n) {
            default: {
                this.basis = new Noise();
                break;
            }
            case 1: {
                this.basis = new RidgedFBM();
                break;
            }
            case 2: {
                this.basis = new VLNoise();
                break;
            }
            case 3: {
                this.basis = new SCNoise();
                break;
            }
            case 4: {
                this.basis = new CellularFunction2D();
            }
        }
    }

    public int getBasisType() {
        return this.basisType;
    }

    public void setBasis(Function2D function2D) {
        this.basis = function2D;
    }

    public Function2D getBasis() {
        return this.basis;
    }

    protected FBM makeFBM(float f2, float f3, float f4) {
        FBM fBM = new FBM(f2, f3, f4, this.basis);
        float[] fArray = Noise.findRange(fBM, null);
        this.min = fArray[0];
        this.max = fArray[1];
        return fBM;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.fBm = this.makeFBM(this.H, this.lacunarity, this.octaves);
        return super.filter(bufferedImage, bufferedImage2);
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4;
        float f2 = this.m00 * (float)n + this.m01 * (float)n2;
        float f3 = this.m10 * (float)n + this.m11 * (float)n2;
        float f4 = this.fBm.evaluate(f2 /= this.scale, f3 /= this.scale * this.stretch);
        f4 = (f4 - this.min) / (this.max - this.min);
        f4 = ImageMath.gain(f4, this.gain);
        f4 = ImageMath.bias(f4, this.bias);
        f4 *= this.amount;
        int n5 = n3 & 0xFF000000;
        if (this.colormap != null) {
            n4 = this.colormap.getColor(f4);
        } else {
            n4 = PixelUtils.clamp((int)(f4 * 255.0f));
            int n6 = n4 << 16;
            int n7 = n4 << 8;
            int n8 = n4;
            n4 = n5 | n6 | n7 | n8;
        }
        if (this.operation != 0) {
            n4 = PixelUtils.combinePixels(n3, n4, this.operation);
        }
        return n4;
    }

    public String toString() {
        return "Texture/Fractal Brownian Motion...";
    }
}

