/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class FeedbackFilter
extends AbstractBufferedImageOp {
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float distance;
    private float angle;
    private float rotation;
    private float zoom;
    private float startAlpha = 1.0f;
    private float endAlpha = 1.0f;
    private int iterations;

    public FeedbackFilter() {
    }

    public FeedbackFilter(float f2, float f3, float f4, float f5) {
        this.distance = f2;
        this.angle = f3;
        this.rotation = f4;
        this.zoom = f5;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setDistance(float f2) {
        this.distance = f2;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setRotation(float f2) {
        this.rotation = f2;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setZoom(float f2) {
        this.zoom = f2;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setStartAlpha(float f2) {
        this.startAlpha = f2;
    }

    public float getStartAlpha() {
        return this.startAlpha;
    }

    public void setEndAlpha(float f2) {
        this.endAlpha = f2;
    }

    public float getEndAlpha() {
        return this.endAlpha;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public int getIterations() {
        return this.iterations;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        float f2 = (float)bufferedImage.getWidth() * this.centreX;
        float f3 = (float)bufferedImage.getHeight() * this.centreY;
        float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        float f5 = (float)((double)this.distance * Math.cos(this.angle));
        float f6 = (float)((double)this.distance * -Math.sin(this.angle));
        float f7 = (float)Math.exp(this.zoom);
        float f8 = this.rotation;
        if (this.iterations == 0) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawRenderedImage(bufferedImage, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, null);
        for (int i = 0; i < this.iterations; ++i) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setComposite(AlphaComposite.getInstance(3, ImageMath.lerp((float)i / (float)(this.iterations - 1), this.startAlpha, this.endAlpha)));
            graphics2D.translate(f2 + f5, f3 + f6);
            graphics2D.scale(f7, f7);
            if (this.rotation != 0.0f) {
                graphics2D.rotate(f8);
            }
            graphics2D.translate(-f2, -f3);
            graphics2D.drawImage(bufferedImage, null, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public String toString() {
        return "Effects/Feedback...";
    }
}

