/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.Noise;
import java.awt.geom.Point2D;

public class FlareFilter
extends PointFilter {
    private int rays = 50;
    private float radius;
    private float baseAmount = 1.0f;
    private float ringAmount = 0.2f;
    private float rayAmount = 0.1f;
    private int color = -1;
    private int width;
    private int height;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float ringWidth = 1.6f;
    private float linear = 0.03f;
    private float gauss = 0.006f;
    private float mix = 0.5f;
    private float falloff = 6.0f;
    private float sigma;
    private float icentreX;
    private float icentreY;

    public FlareFilter() {
        this.setRadius(50.0f);
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setRingWidth(float f2) {
        this.ringWidth = f2;
    }

    public float getRingWidth() {
        return this.ringWidth;
    }

    public void setBaseAmount(float f2) {
        this.baseAmount = f2;
    }

    public float getBaseAmount() {
        return this.baseAmount;
    }

    public void setRingAmount(float f2) {
        this.ringAmount = f2;
    }

    public float getRingAmount() {
        return this.ringAmount;
    }

    public void setRayAmount(float f2) {
        this.rayAmount = f2;
    }

    public float getRayAmount() {
        return this.rayAmount;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setRadius(float f2) {
        this.radius = f2;
        this.sigma = f2 / 3.0f;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.icentreX = this.centreX * (float)n;
        this.icentreY = this.centreY * (float)n2;
        super.setDimensions(n, n2);
    }

    public int filterRGB(int n, int n2, int n3) {
        float f2;
        float f3 = (float)n - this.icentreX;
        float f4 = (float)n2 - this.icentreY;
        float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
        float f6 = (float)Math.exp(-f5 * f5 * this.gauss) * this.mix + (float)Math.exp(-f5 * this.linear) * (1.0f - this.mix);
        f6 *= this.baseAmount;
        if (f5 > this.radius + this.ringWidth) {
            f6 = ImageMath.lerp((f5 - (this.radius + this.ringWidth)) / this.falloff, f6, 0.0f);
        }
        if (f5 < this.radius - this.ringWidth || f5 > this.radius + this.ringWidth) {
            f2 = 0.0f;
        } else {
            f2 = Math.abs(f5 - this.radius) / this.ringWidth;
            f2 = 1.0f - f2 * f2 * (3.0f - 2.0f * f2);
            f2 *= this.ringAmount;
        }
        f6 += f2;
        float f7 = (float)Math.atan2(f3, f4) + (float)Math.PI;
        f7 = (ImageMath.mod(f7 / (float)Math.PI * 17.0f + 1.0f + Noise.noise1(f7 * 10.0f), 1.0f) - 0.5f) * 2.0f;
        f7 = Math.abs(f7);
        f7 = (float)Math.pow(f7, 5.0);
        float f8 = this.rayAmount * f7 / (1.0f + f5 * 0.1f);
        f6 += f8;
        f6 = ImageMath.clamp(f6, 0.0f, 1.0f);
        return ImageMath.mixColors(f6, n3, this.color);
    }

    public String toString() {
        return "Stylize/Flare...";
    }
}

