/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransferFilter;

public class GammaFilter
extends TransferFilter {
    private float rGamma;
    private float gGamma;
    private float bGamma;

    public GammaFilter() {
        this(1.0f);
    }

    public GammaFilter(float f2) {
        this(f2, f2, f2);
    }

    public GammaFilter(float f2, float f3, float f4) {
        this.setGamma(f2, f3, f4);
    }

    public void setGamma(float f2, float f3, float f4) {
        this.rGamma = f2;
        this.gGamma = f3;
        this.bGamma = f4;
        this.initialized = false;
    }

    public void setGamma(float f2) {
        this.setGamma(f2, f2, f2);
    }

    public float getGamma() {
        return this.rGamma;
    }

    protected void initialize() {
        this.rTable = this.makeTable(this.rGamma);
        this.gTable = this.gGamma == this.rGamma ? this.rTable : this.makeTable(this.gGamma);
        this.bTable = this.bGamma == this.rGamma ? this.rTable : (this.bGamma == this.gGamma ? this.gTable : this.makeTable(this.bGamma));
    }

    protected int[] makeTable(float f2) {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = (int)(255.0 * Math.pow((double)i / 255.0, 1.0 / (double)f2) + 0.5);
            if (n > 255) {
                n = 255;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public String toString() {
        return "Colors/Gamma...";
    }
}

