/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ConvolveFilter;
import com.jhlabs.image.PixelUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;

public class GaussianFilter
extends ConvolveFilter {
    protected float radius;
    protected Kernel kernel;

    public GaussianFilter() {
        this(2.0f);
    }

    public GaussianFilter(float f2) {
        this.setRadius(f2);
    }

    public void setRadius(float f2) {
        this.radius = f2;
        this.kernel = GaussianFilter.makeKernel(f2);
    }

    public float getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        if (this.radius > 0.0f) {
            GaussianFilter.convolveAndTranspose(this.kernel, nArray, nArray2, n, n2, this.alpha, ConvolveFilter.CLAMP_EDGES);
            GaussianFilter.convolveAndTranspose(this.kernel, nArray2, nArray, n2, n, this.alpha, ConvolveFilter.CLAMP_EDGES);
        }
        bufferedImage2.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage2;
    }

    public static void convolveAndTranspose(Kernel kernel, int[] nArray, int[] nArray2, int n, int n2, boolean bl, int n3) {
        float[] fArray = kernel.getKernelData(null);
        int n4 = kernel.getWidth();
        int n5 = n4 / 2;
        for (int i = 0; i < n2; ++i) {
            int n6 = i;
            int n7 = i * n;
            for (int j = 0; j < n; ++j) {
                int n8;
                int n9;
                int n10;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                int n11 = n5;
                for (n10 = -n5; n10 <= n5; ++n10) {
                    float f6 = fArray[n11 + n10];
                    if (f6 == 0.0f) continue;
                    n9 = j + n10;
                    if (n9 < 0) {
                        if (n3 == ConvolveFilter.CLAMP_EDGES) {
                            n9 = 0;
                        } else if (n3 == ConvolveFilter.WRAP_EDGES) {
                            n9 = (j + n) % n;
                        }
                    } else if (n9 >= n) {
                        if (n3 == ConvolveFilter.CLAMP_EDGES) {
                            n9 = n - 1;
                        } else if (n3 == ConvolveFilter.WRAP_EDGES) {
                            n9 = (j + n) % n;
                        }
                    }
                    n8 = nArray[n7 + n9];
                    f5 += f6 * (float)(n8 >> 24 & 0xFF);
                    f2 += f6 * (float)(n8 >> 16 & 0xFF);
                    f3 += f6 * (float)(n8 >> 8 & 0xFF);
                    f4 += f6 * (float)(n8 & 0xFF);
                }
                n10 = bl ? PixelUtils.clamp((int)((double)f5 + 0.5)) : 255;
                int n12 = PixelUtils.clamp((int)((double)f2 + 0.5));
                n9 = PixelUtils.clamp((int)((double)f3 + 0.5));
                n8 = PixelUtils.clamp((int)((double)f4 + 0.5));
                nArray2[n6] = n10 << 24 | n12 << 16 | n9 << 8 | n8;
                n6 += n2;
            }
        }
    }

    public static Kernel makeKernel(float f2) {
        int n;
        int n2 = (int)Math.ceil(f2);
        int n3 = n2 * 2 + 1;
        float[] fArray = new float[n3];
        float f3 = f2 / 3.0f;
        float f4 = 2.0f * f3 * f3;
        float f5 = (float)Math.PI * 2 * f3;
        float f6 = (float)Math.sqrt(f5);
        float f7 = f2 * f2;
        float f8 = 0.0f;
        int n4 = 0;
        for (n = -n2; n <= n2; ++n) {
            float f9 = n * n;
            fArray[n4] = f9 > f7 ? 0.0f : (float)Math.exp(-f9 / f4) / f6;
            f8 += fArray[n4];
            ++n4;
        }
        n = 0;
        while (n < n3) {
            int n5 = n++;
            fArray[n5] = fArray[n5] / f8;
        }
        return new Kernel(n3, 1, fArray);
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

