/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class KaleidoscopeFilter
extends TransformFilter {
    private float angle = 0.0f;
    private float angle2 = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private int sides = 3;
    private float radius = 0.0f;
    private float icentreX;
    private float icentreY;

    public KaleidoscopeFilter() {
        this.setEdgeAction(1);
    }

    public void setSides(int n) {
        this.sides = n;
    }

    public int getSides() {
        return this.sides;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle2(float f2) {
        this.angle2 = f2;
    }

    public float getAngle2() {
        return this.angle2;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    public float getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.icentreX = (float)bufferedImage.getWidth() * this.centreX;
        this.icentreY = (float)bufferedImage.getHeight() * this.centreY;
        return super.filter(bufferedImage, bufferedImage2);
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        double d2 = (float)n - this.icentreX;
        double d3 = (float)n2 - this.icentreY;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = Math.atan2(d3, d2) - (double)this.angle - (double)this.angle2;
        d5 = ImageMath.triangle((float)(d5 / Math.PI * (double)this.sides * 0.5));
        if (this.radius != 0.0f) {
            double d6 = Math.cos(d5);
            double d7 = (double)this.radius / d6;
            d4 = d7 * (double)ImageMath.triangle((float)(d4 / d7));
        }
        fArray[0] = (float)((double)this.icentreX + d4 * Math.cos(d5 += (double)this.angle));
        fArray[1] = (float)((double)this.icentreY + d4 * Math.sin(d5));
    }

    public String toString() {
        return "Distort/Kaleidoscope...";
    }
}

