/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.OctTreeQuantizer$OctTreeNode;
import com.jhlabs.image.Quantizer;
import java.util.Vector;

public class OctTreeQuantizer
implements Quantizer {
    static final int MAX_LEVEL = 5;
    private int nodes = 0;
    private OctTreeQuantizer$OctTreeNode root;
    private int reduceColors;
    private int maximumColors;
    private int colors = 0;
    private Vector[] colorList;

    public OctTreeQuantizer() {
        this.setup(256);
        this.colorList = new Vector[6];
        for (int i = 0; i < 6; ++i) {
            this.colorList[i] = new Vector();
        }
        this.root = new OctTreeQuantizer$OctTreeNode(this);
    }

    public void setup(int n) {
        this.maximumColors = n;
        this.reduceColors = Math.max(512, n * 2);
    }

    public void addPixels(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.insertColor(nArray[i + n]);
            if (this.colors <= this.reduceColors) continue;
            this.reduceTree(this.reduceColors);
        }
    }

    public int getIndexForColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode = this.root;
        for (int i = 0; i <= 5; ++i) {
            OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode2;
            int n5 = 128 >> i;
            int n6 = 0;
            if ((n2 & n5) != 0) {
                n6 += 4;
            }
            if ((n3 & n5) != 0) {
                n6 += 2;
            }
            if ((n4 & n5) != 0) {
                ++n6;
            }
            if ((octTreeQuantizer$OctTreeNode2 = octTreeQuantizer$OctTreeNode.leaf[n6]) == null) {
                return octTreeQuantizer$OctTreeNode.index;
            }
            if (octTreeQuantizer$OctTreeNode2.isLeaf) {
                return octTreeQuantizer$OctTreeNode2.index;
            }
            octTreeQuantizer$OctTreeNode = octTreeQuantizer$OctTreeNode2;
        }
        System.out.println("getIndexForColor failed");
        return 0;
    }

    private void insertColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode = this.root;
        for (int i = 0; i <= 5; ++i) {
            OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode2;
            int n5 = 128 >> i;
            int n6 = 0;
            if ((n2 & n5) != 0) {
                n6 += 4;
            }
            if ((n3 & n5) != 0) {
                n6 += 2;
            }
            if ((n4 & n5) != 0) {
                ++n6;
            }
            if ((octTreeQuantizer$OctTreeNode2 = octTreeQuantizer$OctTreeNode.leaf[n6]) == null) {
                ++octTreeQuantizer$OctTreeNode.children;
                octTreeQuantizer$OctTreeNode2 = new OctTreeQuantizer$OctTreeNode(this);
                octTreeQuantizer$OctTreeNode2.parent = octTreeQuantizer$OctTreeNode;
                octTreeQuantizer$OctTreeNode.leaf[n6] = octTreeQuantizer$OctTreeNode2;
                octTreeQuantizer$OctTreeNode.isLeaf = false;
                ++this.nodes;
                this.colorList[i].addElement(octTreeQuantizer$OctTreeNode2);
                if (i == 5) {
                    octTreeQuantizer$OctTreeNode2.isLeaf = true;
                    octTreeQuantizer$OctTreeNode2.count = 1;
                    octTreeQuantizer$OctTreeNode2.totalRed = n2;
                    octTreeQuantizer$OctTreeNode2.totalGreen = n3;
                    octTreeQuantizer$OctTreeNode2.totalBlue = n4;
                    octTreeQuantizer$OctTreeNode2.level = i;
                    ++this.colors;
                    return;
                }
                octTreeQuantizer$OctTreeNode = octTreeQuantizer$OctTreeNode2;
                continue;
            }
            if (octTreeQuantizer$OctTreeNode2.isLeaf) {
                ++octTreeQuantizer$OctTreeNode2.count;
                octTreeQuantizer$OctTreeNode2.totalRed += n2;
                octTreeQuantizer$OctTreeNode2.totalGreen += n3;
                octTreeQuantizer$OctTreeNode2.totalBlue += n4;
                return;
            }
            octTreeQuantizer$OctTreeNode = octTreeQuantizer$OctTreeNode2;
        }
        System.out.println("insertColor failed");
    }

    private void reduceTree(int n) {
        for (int i = 4; i >= 0; --i) {
            Vector vector = this.colorList[i];
            if (vector == null || vector.size() <= 0) continue;
            for (int j = 0; j < vector.size(); ++j) {
                OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode = (OctTreeQuantizer$OctTreeNode)vector.elementAt(j);
                if (octTreeQuantizer$OctTreeNode.children <= 0) continue;
                for (int k = 0; k < 8; ++k) {
                    OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode2 = octTreeQuantizer$OctTreeNode.leaf[k];
                    if (octTreeQuantizer$OctTreeNode2 == null) continue;
                    if (!octTreeQuantizer$OctTreeNode2.isLeaf) {
                        System.out.println("not a leaf!");
                    }
                    octTreeQuantizer$OctTreeNode.count += octTreeQuantizer$OctTreeNode2.count;
                    octTreeQuantizer$OctTreeNode.totalRed += octTreeQuantizer$OctTreeNode2.totalRed;
                    octTreeQuantizer$OctTreeNode.totalGreen += octTreeQuantizer$OctTreeNode2.totalGreen;
                    octTreeQuantizer$OctTreeNode.totalBlue += octTreeQuantizer$OctTreeNode2.totalBlue;
                    octTreeQuantizer$OctTreeNode.leaf[k] = null;
                    --octTreeQuantizer$OctTreeNode.children;
                    --this.colors;
                    --this.nodes;
                    this.colorList[i + 1].removeElement(octTreeQuantizer$OctTreeNode2);
                }
                octTreeQuantizer$OctTreeNode.isLeaf = true;
                ++this.colors;
                if (this.colors > n) continue;
                return;
            }
        }
        System.out.println("Unable to reduce the OctTree");
    }

    public int[] buildColorTable() {
        int[] nArray = new int[this.colors];
        this.buildColorTable(this.root, nArray, 0);
        return nArray;
    }

    public void buildColorTable(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        this.maximumColors = nArray2.length;
        for (int i = 0; i < n; ++i) {
            this.insertColor(nArray[i]);
            if (this.colors <= this.reduceColors) continue;
            this.reduceTree(this.reduceColors);
        }
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        this.buildColorTable(this.root, nArray2, 0);
    }

    private int buildColorTable(OctTreeQuantizer$OctTreeNode octTreeQuantizer$OctTreeNode, int[] nArray, int n) {
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        if (octTreeQuantizer$OctTreeNode.isLeaf) {
            int n2 = octTreeQuantizer$OctTreeNode.count;
            nArray[n] = 0xFF000000 | octTreeQuantizer$OctTreeNode.totalRed / n2 << 16 | octTreeQuantizer$OctTreeNode.totalGreen / n2 << 8 | octTreeQuantizer$OctTreeNode.totalBlue / n2;
            octTreeQuantizer$OctTreeNode.index = n++;
        } else {
            for (int i = 0; i < 8; ++i) {
                if (octTreeQuantizer$OctTreeNode.leaf[i] == null) continue;
                octTreeQuantizer$OctTreeNode.index = n;
                n = this.buildColorTable(octTreeQuantizer$OctTreeNode.leaf[i], nArray, n);
            }
        }
        return n;
    }
}

