/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.Rectangle;

public class PerspectiveFilter
extends TransformFilter {
    private float x0;
    private float y0;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float x3;
    private float y3;
    private float dx1;
    private float dy1;
    private float dx2;
    private float dy2;
    private float dx3;
    private float dy3;
    private float A;
    private float B;
    private float C;
    private float D;
    private float E;
    private float F;
    private float G;
    private float H;
    private float I;

    public PerspectiveFilter() {
        this(0.0f, 0.0f, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
    }

    public PerspectiveFilter(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.setCorners(f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void setCorners(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        this.x0 = f2;
        this.y0 = f3;
        this.x1 = f4;
        this.y1 = f5;
        this.x2 = f6;
        this.y2 = f7;
        this.x3 = f8;
        this.y3 = f9;
        this.dx1 = f4 - f6;
        this.dy1 = f5 - f7;
        this.dx2 = f8 - f6;
        this.dy2 = f9 - f7;
        this.dx3 = f2 - f4 + f6 - f8;
        this.dy3 = f3 - f5 + f7 - f9;
        if (this.dx3 == 0.0f && this.dy3 == 0.0f) {
            f17 = f4 - f2;
            f16 = f6 - f4;
            f15 = f2;
            f14 = f5 - f3;
            f13 = f7 - f5;
            f12 = f3;
            f11 = 0.0f;
            f10 = 0.0f;
        } else {
            f10 = (this.dx3 * this.dy2 - this.dx2 * this.dy3) / (this.dx1 * this.dy2 - this.dy1 * this.dx2);
            f11 = (this.dx1 * this.dy3 - this.dy1 * this.dx3) / (this.dx1 * this.dy2 - this.dy1 * this.dx2);
            f17 = f4 - f2 + f10 * f4;
            f16 = f8 - f2 + f11 * f8;
            f15 = f2;
            f14 = f5 - f3 + f10 * f5;
            f13 = f9 - f3 + f11 * f9;
            f12 = f3;
        }
        this.A = f13 - f12 * f11;
        this.B = f15 * f11 - f16;
        this.C = f16 * f12 - f15 * f13;
        this.D = f12 * f10 - f14;
        this.E = f17 - f15 * f10;
        this.F = f15 * f14 - f17 * f12;
        this.G = f14 * f11 - f13 * f10;
        this.H = f16 * f10 - f17 * f11;
        this.I = f17 * f13 - f16 * f14;
    }

    protected void transformSpace(Rectangle rectangle) {
        rectangle.x = (int)Math.min(Math.min(this.x0, this.x1), Math.min(this.x2, this.x3));
        rectangle.y = (int)Math.min(Math.min(this.y0, this.y1), Math.min(this.y2, this.y3));
        rectangle.width = (int)Math.max(Math.max(this.x0, this.x1), Math.max(this.x2, this.x3)) - rectangle.x;
        rectangle.height = (int)Math.max(Math.max(this.y0, this.y1), Math.max(this.y2, this.y3)) - rectangle.y;
    }

    public float getOriginX() {
        return this.x0 - (float)((int)Math.min(Math.min(this.x0, this.x1), Math.min(this.x2, this.x3)));
    }

    public float getOriginY() {
        return this.y0 - (float)((int)Math.min(Math.min(this.y0, this.y1), Math.min(this.y2, this.y3)));
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        fArray[0] = (float)this.originalSpace.width * (this.A * (float)n + this.B * (float)n2 + this.C) / (this.G * (float)n + this.H * (float)n2 + this.I);
        fArray[1] = (float)this.originalSpace.height * (this.D * (float)n + this.E * (float)n2 + this.F) / (this.G * (float)n + this.H * (float)n2 + this.I);
    }

    public String toString() {
        return "Distort/Perspective...";
    }
}

