/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;

public class QuiltFilter
extends WholeImageFilter
implements Serializable {
    private Random randomGenerator;
    private long seed = 567L;
    private int iterations = 25000;
    private float a = -0.59f;
    private float b = 0.2f;
    private float c = 0.1f;
    private float d = 0.0f;
    private int k = 0;
    private Colormap colormap = new LinearColormap();

    public QuiltFilter() {
        this.randomGenerator = new Random();
    }

    public void randomize() {
        this.seed = new Date().getTime();
        this.randomGenerator.setSeed(this.seed);
        this.a = this.randomGenerator.nextFloat();
        this.b = this.randomGenerator.nextFloat();
        this.c = this.randomGenerator.nextFloat();
        this.d = this.randomGenerator.nextFloat();
        this.k = this.randomGenerator.nextInt() % 20 - 10;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setA(float f2) {
        this.a = f2;
    }

    public float getA() {
        return this.a;
    }

    public void setB(float f2) {
        this.b = f2;
    }

    public float getB() {
        return this.b;
    }

    public void setC(float f2) {
        this.c = f2;
    }

    public float getC() {
        return this.c;
    }

    public void setD(float f2) {
        this.d = f2;
    }

    public float getD() {
        return this.d;
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    protected int[] filterPixels(int n, int n2, int[] nArray, Rectangle rectangle) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n3;
        int[] nArray2 = new int[n * n2];
        boolean bl = false;
        int n4 = 0;
        float f6 = 0.1f;
        float f7 = 0.3f;
        for (n3 = 0; n3 < 20; ++n3) {
            f5 = (float)Math.PI * f6;
            f4 = (float)Math.PI * f7;
            f3 = (float)Math.sin(2.0f * f5);
            f2 = (float)Math.sin(2.0f * f4);
            float f8 = (float)((double)(this.a * f3) + (double)(this.b * f3) * Math.cos(2.0f * f4) + (double)this.c * Math.sin(4.0f * f5) + (double)this.d * Math.sin(6.0f * f5) * Math.cos(4.0f * f4) + (double)((float)this.k * f6));
            f8 = f8 >= 0.0f ? f8 - (float)((int)f8) : f8 - (float)((int)f8) + 1.0f;
            float f9 = (float)((double)(this.a * f2) + (double)(this.b * f2) * Math.cos(2.0f * f5) + (double)this.c * Math.sin(4.0f * f4) + (double)this.d * Math.sin(6.0f * f4) * Math.cos(4.0f * f5) + (double)((float)this.k * f7));
            f9 = f9 >= 0.0f ? f9 - (float)((int)f9) : f9 - (float)((int)f9) + 1.0f;
            f6 = f8;
            f7 = f9;
        }
        for (n3 = 0; n3 < this.iterations; ++n3) {
            int n5;
            f5 = (float)Math.PI * f6;
            f4 = (float)Math.PI * f7;
            f3 = (float)((double)this.a * Math.sin(2.0f * f5) + (double)this.b * Math.sin(2.0f * f5) * Math.cos(2.0f * f4) + (double)this.c * Math.sin(4.0f * f5) + (double)this.d * Math.sin(6.0f * f5) * Math.cos(4.0f * f4) + (double)((float)this.k * f6));
            f3 = f3 >= 0.0f ? f3 - (float)((int)f3) : f3 - (float)((int)f3) + 1.0f;
            f2 = (float)((double)this.a * Math.sin(2.0f * f4) + (double)this.b * Math.sin(2.0f * f4) * Math.cos(2.0f * f5) + (double)this.c * Math.sin(4.0f * f4) + (double)this.d * Math.sin(6.0f * f4) * Math.cos(4.0f * f5) + (double)((float)this.k * f7));
            f2 = f2 >= 0.0f ? f2 - (float)((int)f2) : f2 - (float)((int)f2) + 1.0f;
            f6 = f3;
            f7 = f2;
            int n6 = (int)((float)n * f6);
            int n7 = (int)((float)n2 * f7);
            if (n6 < 0 || n6 >= n || n7 < 0 || n7 >= n2) continue;
            int n8 = n * n7 + n6;
            nArray2[n8] = nArray2[n8] + 1;
            if (n5 <= n4) continue;
            n4 = n5;
        }
        if (this.colormap != null) {
            n3 = 0;
            for (f7 = 0.0f; f7 < (float)n2; f7 += 1.0f) {
                for (f6 = 0.0f; f6 < (float)n; f6 += 1.0f) {
                    nArray2[n3] = this.colormap.getColor((float)nArray2[n3] / (float)n4);
                    ++n3;
                }
            }
        }
        return nArray2;
    }

    public String toString() {
        return "Texture/Chaotic Quilt...";
    }
}

