/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import java.io.Serializable;

public class RGBAdjustFilter
extends PointFilter
implements Serializable {
    public float rFactor;
    public float gFactor;
    public float bFactor;

    public RGBAdjustFilter() {
        this(0.0f, 0.0f, 0.0f);
    }

    public RGBAdjustFilter(float f2, float f3, float f4) {
        this.rFactor = 1.0f + f2;
        this.gFactor = 1.0f + f3;
        this.bFactor = 1.0f + f4;
        this.canFilterIndexColorModel = true;
    }

    public void setRFactor(float f2) {
        this.rFactor = 1.0f + f2;
    }

    public float getRFactor() {
        return this.rFactor - 1.0f;
    }

    public void setGFactor(float f2) {
        this.gFactor = 1.0f + f2;
    }

    public float getGFactor() {
        return this.gFactor - 1.0f;
    }

    public void setBFactor(float f2) {
        this.bFactor = 1.0f + f2;
    }

    public float getBFactor() {
        return this.bFactor - 1.0f;
    }

    public int[] getLUT() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = this.filterRGB(0, 0, i << 24 | i << 16 | i << 8 | i);
        }
        return nArray;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        n5 = PixelUtils.clamp((int)((float)n5 * this.rFactor));
        n6 = PixelUtils.clamp((int)((float)n6 * this.gFactor));
        n7 = PixelUtils.clamp((int)((float)n7 * this.bFactor));
        return n4 | n5 << 16 | n6 << 8 | n7;
    }

    public String toString() {
        return "Colors/Adjust RGB...";
    }
}

