/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PointFilter;
import java.io.Serializable;
import java.util.Random;

public class SparkleFilter
extends PointFilter
implements Serializable {
    static final long serialVersionUID = 1692413049411710802L;
    private int rays = 50;
    private int radius = 25;
    private int amount = 50;
    private int color = -1;
    private int randomness = 25;
    private int width;
    private int height;
    private int centreX;
    private int centreY;
    private long seed = 371L;
    private float[] rayLengths;
    private Random randomNumbers = new Random();

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setRandomness(int n) {
        this.randomness = n;
    }

    public int getRandomness() {
        return this.randomness;
    }

    public void setAmount(int n) {
        this.amount = n;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setRays(int n) {
        this.rays = n;
    }

    public int getRays() {
        return this.rays;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.centreX = n / 2;
        this.centreY = n2 / 2;
        super.setDimensions(n, n2);
        this.randomNumbers.setSeed(this.seed);
        this.rayLengths = new float[this.rays];
        for (int i = 0; i < this.rays; ++i) {
            this.rayLengths[i] = (float)this.radius + (float)this.randomness / 100.0f * (float)this.radius * (float)this.randomNumbers.nextGaussian();
        }
    }

    public int filterRGB(int n, int n2, int n3) {
        float f2 = n - this.centreX;
        float f3 = n2 - this.centreY;
        float f4 = f2 * f2 + f3 * f3;
        float f5 = (float)Math.atan2(f3, f2);
        float f6 = (f5 + (float)Math.PI) / ((float)Math.PI * 2) * (float)this.rays;
        int n4 = (int)f6;
        float f7 = f6 - (float)n4;
        if (this.radius != 0) {
            float f8 = ImageMath.lerp(f7, this.rayLengths[n4 % this.rays], this.rayLengths[(n4 + 1) % this.rays]);
            float f9 = f8 * f8 / (f4 + 1.0E-4f);
            f9 = (float)Math.pow(f9, (double)(100 - this.amount) / 50.0);
            f7 -= 0.5f;
            f7 = 1.0f - f7 * f7;
            f7 *= f9;
        }
        f7 = ImageMath.clamp(f7, 0.0f, 1.0f);
        return ImageMath.mixColors(f7, n3, this.color);
    }

    public String toString() {
        return "Stylize/Sparkle...";
    }
}

