/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PointFilter;
import java.io.Serializable;

public class WeaveFilter
extends PointFilter
implements Serializable {
    static final long serialVersionUID = 4847932412277504482L;
    private float xWidth = 16.0f;
    private float yWidth = 16.0f;
    private float xGap = 6.0f;
    private float yGap = 6.0f;
    private int rows = 4;
    private int cols = 4;
    private int rgbX = -32640;
    private int rgbY = -8355585;
    private boolean useImageColors = true;
    private boolean roundThreads = false;
    private boolean shadeCrossings = true;
    public int[][] matrix = new int[][]{{0, 1, 0, 1}, {1, 0, 1, 0}, {0, 1, 0, 1}, {1, 0, 1, 0}};

    public void setXGap(float f2) {
        this.xGap = f2;
    }

    public void setXWidth(float f2) {
        this.xWidth = f2;
    }

    public float getXWidth() {
        return this.xWidth;
    }

    public void setYWidth(float f2) {
        this.yWidth = f2;
    }

    public float getYWidth() {
        return this.yWidth;
    }

    public float getXGap() {
        return this.xGap;
    }

    public void setYGap(float f2) {
        this.yGap = f2;
    }

    public float getYGap() {
        return this.yGap;
    }

    public void setCrossings(int[][] nArray) {
        this.matrix = nArray;
    }

    public int[][] getCrossings() {
        return this.matrix;
    }

    public void setUseImageColors(boolean bl) {
        this.useImageColors = bl;
    }

    public boolean getUseImageColors() {
        return this.useImageColors;
    }

    public void setRoundThreads(boolean bl) {
        this.roundThreads = bl;
    }

    public boolean getRoundThreads() {
        return this.roundThreads;
    }

    public void setShadeCrossings(boolean bl) {
        this.shadeCrossings = bl;
    }

    public boolean getShadeCrossings() {
        return this.shadeCrossings;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        n = (int)((float)n + (this.xWidth + this.xGap / 2.0f));
        n2 = (int)((float)n2 + (this.yWidth + this.yGap / 2.0f));
        float f6 = ImageMath.mod((float)n, this.xWidth + this.xGap);
        float f7 = ImageMath.mod((float)n2, this.yWidth + this.yGap);
        int n7 = (int)((float)n / (this.xWidth + this.xGap));
        int n8 = (int)((float)n2 / (this.yWidth + this.yGap));
        boolean bl2 = f6 < this.xWidth;
        boolean bl3 = bl = f7 < this.yWidth;
        if (this.roundThreads) {
            f5 = Math.abs(this.xWidth / 2.0f - f6) / this.xWidth / 2.0f;
            f4 = Math.abs(this.yWidth / 2.0f - f7) / this.yWidth / 2.0f;
        } else {
            f4 = 0.0f;
            f5 = 0.0f;
        }
        if (this.shadeCrossings) {
            f3 = ImageMath.smoothStep(this.xWidth / 2.0f, this.xWidth / 2.0f + this.xGap, Math.abs(this.xWidth / 2.0f - f6));
            f2 = ImageMath.smoothStep(this.yWidth / 2.0f, this.yWidth / 2.0f + this.yGap, Math.abs(this.yWidth / 2.0f - f7));
        } else {
            f2 = 0.0f;
            f3 = 0.0f;
        }
        if (this.useImageColors) {
            n5 = n6 = n3;
        } else {
            n5 = this.rgbX;
            n6 = this.rgbY;
        }
        int n9 = n7 % this.cols;
        int n10 = n8 % this.rows;
        int n11 = this.matrix[n10][n9];
        if (bl2) {
            if (bl) {
                n4 = n11 == 1 ? n5 : n6;
                n4 = ImageMath.mixColors(2.0f * (n11 == 1 ? f5 : f4), n4, -16777216);
            } else {
                if (this.shadeCrossings) {
                    if (n11 != this.matrix[(n8 + 1) % this.rows][n9]) {
                        if (n11 == 0) {
                            f2 = 1.0f - f2;
                        }
                        n5 = ImageMath.mixColors(f2 *= 0.5f, n5, -16777216);
                    } else if (n11 == 0) {
                        n5 = ImageMath.mixColors(0.5f, n5, -16777216);
                    }
                }
                n4 = ImageMath.mixColors(2.0f * f5, n5, -16777216);
            }
        } else if (bl) {
            if (this.shadeCrossings) {
                if (n11 != this.matrix[n10][(n7 + 1) % this.cols]) {
                    if (n11 == 1) {
                        f3 = 1.0f - f3;
                    }
                    n6 = ImageMath.mixColors(f3 *= 0.5f, n6, -16777216);
                } else if (n11 == 1) {
                    n6 = ImageMath.mixColors(0.5f, n6, -16777216);
                }
            }
            n4 = ImageMath.mixColors(2.0f * f4, n6, -16777216);
        } else {
            n4 = 0;
        }
        return n4;
    }

    public String toString() {
        return "Texture/Weave...";
    }
}

