/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

class BiCubicFilter
implements ResampleFilter {
    protected final float a;

    public BiCubicFilter() {
        this.a = -0.5f;
    }

    protected BiCubicFilter(float f2) {
        this.a = f2;
    }

    public final float apply(float f2) {
        if (f2 == 0.0f) {
            return 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        float f3 = f2 * f2;
        if (f2 < 1.0f) {
            return (this.a + 2.0f) * f3 * f2 - (this.a + 3.0f) * f3 + 1.0f;
        }
        if (f2 < 2.0f) {
            return this.a * f3 * f2 - 5.0f * this.a * f3 + 8.0f * this.a * f2 - 4.0f * this.a;
        }
        return 0.0f;
    }

    public float getSamplingRadius() {
        return 2.0f;
    }

    public String getName() {
        return "BiCubic";
    }
}

