/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ImageUtils {
    public static String imageTypeName(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 5: {
                return "TYPE_3BYTE_BGR";
            }
            case 6: {
                return "TYPE_4BYTE_ABGR";
            }
            case 7: {
                return "TYPE_4BYTE_ABGR_PRE";
            }
            case 12: {
                return "TYPE_BYTE_BINARY";
            }
            case 10: {
                return "TYPE_BYTE_GRAY";
            }
            case 13: {
                return "TYPE_BYTE_INDEXED";
            }
            case 0: {
                return "TYPE_CUSTOM";
            }
            case 2: {
                return "TYPE_INT_ARGB";
            }
            case 3: {
                return "TYPE_INT_ARGB_PRE";
            }
            case 4: {
                return "TYPE_INT_BGR";
            }
            case 1: {
                return "TYPE_INT_RGB";
            }
            case 9: {
                return "TYPE_USHORT_555_RGB";
            }
            case 8: {
                return "TYPE_USHORT_565_RGB";
            }
            case 11: {
                return "TYPE_USHORT_GRAY";
            }
        }
        return "unknown image type #" + bufferedImage.getType();
    }

    public static int nrChannels(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 10: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 9: {
                return 3;
            }
            case 8: {
                return 3;
            }
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    public static byte[] getPixelsBGR(BufferedImage bufferedImage, int n, int n2, byte[] byArray, int[] nArray) {
        boolean bl = false;
        boolean bl2 = true;
        assert (byArray.length == nArray.length * ImageUtils.nrChannels(bufferedImage));
        assert (nArray.length == n2);
        int n3 = bufferedImage.getType();
        switch (n3) {
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                writableRaster.getDataElements(0, n, n2, 1, byArray);
                break;
            }
            case 4: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                writableRaster.getDataElements(0, n, n2, 1, nArray);
                ImageUtils.ints2bytes(nArray, byArray, 0, 1, 2);
                break;
            }
            case 1: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                writableRaster.getDataElements(0, n, n2, 1, nArray);
                ImageUtils.ints2bytes(nArray, byArray, 2, 1, 0);
                break;
            }
            case 2: 
            case 3: {
                WritableRaster writableRaster = bufferedImage.getRaster();
                writableRaster.getDataElements(0, n, n2, 1, nArray);
                ImageUtils.ints2bytes(nArray, byArray, 2, 1, 0, 3);
                break;
            }
            case 0: {
                bufferedImage.getRGB(0, n, n2, 1, nArray, 0, n2);
                ImageUtils.ints2bytes(nArray, byArray, 2, 1, 0, 3);
                break;
            }
            default: {
                bufferedImage.getRGB(0, n, n2, 1, nArray, 0, n2);
                ImageUtils.ints2bytes(nArray, byArray, 2, 1, 0);
            }
        }
        return byArray;
    }

    public static void setBGRPixels(byte[] byArray, BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5 = bufferedImage.getType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (n5 == 5 || n5 == 6 || n5 == 7 || n5 == 10) {
            writableRaster.setDataElements(n, n2, n3, n4, byArray);
        } else {
            int[] nArray = n5 == 4 ? ImageUtils.bytes2int(byArray, 2, 1, 0) : (n5 == 2 || n5 == 3 ? ImageUtils.bytes2int(byArray, 3, 0, 1, 2) : ImageUtils.bytes2int(byArray, 0, 1, 2));
            if (n3 == 0 || n4 == 0) {
                return;
            }
            if (nArray.length < n3 * n4) {
                throw new IllegalArgumentException("pixels array must have a length >= w*h");
            }
            if (n5 == 2 || n5 == 1 || n5 == 3 || n5 == 4) {
                writableRaster.setDataElements(n, n2, n3, n4, nArray);
            } else {
                bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
            }
        }
    }

    public static void ints2bytes(int[] nArray, byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = i * 3;
            int n5 = nArray[i];
            byArray[n4 + n] = (byte)n5;
            byArray[n4 + n2] = (byte)(n5 >>= 8);
            byArray[n4 + n3] = (byte)(n5 >>= 8);
        }
    }

    public static void ints2bytes(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = i * 4;
            int n6 = nArray[i];
            byArray[n5 + n] = (byte)n6;
            byArray[n5 + n2] = (byte)(n6 >>= 8);
            byArray[n5 + n3] = (byte)(n6 >>= 8);
            byArray[n5 + n4] = (byte)(n6 >>= 8);
        }
    }

    public static int[] bytes2int(byte[] byArray, int n, int n2, int n3) {
        int[] nArray = new int[byArray.length / 3];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = i * 3;
            int n5 = (byArray[n4 + n] & 0xFF) << 16;
            int n6 = (byArray[n4 + n2] & 0xFF) << 8;
            int n7 = byArray[n4 + n3] & 0xFF;
            nArray[i] = n5 | n6 | n7;
        }
        return nArray;
    }

    public static int[] bytes2int(byte[] byArray, int n, int n2, int n3, int n4) {
        int[] nArray = new int[byArray.length / 4];
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = i * 4;
            int n6 = (byArray[n5 + n] & 0xFF) << 24;
            int n7 = (byArray[n5 + n2] & 0xFF) << 16;
            int n8 = (byArray[n5 + n3] & 0xFF) << 8;
            int n9 = byArray[n5 + n4] & 0xFF;
            nArray[i] = n6 | n7 | n8 | n9;
        }
        return nArray;
    }

    public static BufferedImage convert(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static byte[] copyJpegMetaData(byte[] byArray, byte[] byArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
        ImageUtils.copyJpegMetaData(new ByteArrayInputStream(byArray), new ByteArrayInputStream(byArray2), memoryCacheImageOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copyJpegMetaData(InputStream inputStream, InputStream inputStream2, ImageOutputStream imageOutputStream) {
        Iterator<Object> iterator = ImageIO.getImageReadersByFormatName("jpeg");
        ImageReader imageReader = iterator.next();
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
        imageReader.setInput(memoryCacheImageInputStream);
        IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
        memoryCacheImageInputStream.close();
        MemoryCacheImageInputStream memoryCacheImageInputStream2 = new MemoryCacheImageInputStream(inputStream2);
        imageReader.setInput(memoryCacheImageInputStream2);
        IIOImage iIOImage = imageReader.readAll(0, null);
        iIOImage.setMetadata(iIOMetadata);
        memoryCacheImageInputStream2.close();
        iterator = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter imageWriter = (ImageWriter)iterator.next();
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(iIOImage);
    }
}

