/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling.experimental;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.experimental.ResampleOpSingleThread$SubSamplingData;
import java.awt.image.BufferedImage;
import java.util.BitSet;

public class ResampleOpSingleThread
extends AdvancedResizeOp {
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private ResampleOpSingleThread$SubSamplingData horizontalSubsamplingData;
    private ResampleOpSingleThread$SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private int totalItems;
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    public ResampleOpSingleThread(int n, int n2) {
        super(DimensionConstrain.createAbsolutionDimension(n, n2));
    }

    public ResampleOpSingleThread(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter resampleFilter) {
        this.filter = resampleFilter;
    }

    public BufferedImage doFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        int n3;
        this.dstWidth = n;
        this.dstHeight = n2;
        if (bufferedImage.getType() == 12 || bufferedImage.getType() == 13 || bufferedImage.getType() == 0) {
            bufferedImage = ImageUtils.convert(bufferedImage, bufferedImage.getColorModel().hasAlpha() ? 6 : 5);
        }
        this.nrChannels = ImageUtils.nrChannels(bufferedImage);
        assert (this.nrChannels > 0);
        this.srcWidth = bufferedImage.getWidth();
        this.srcHeight = bufferedImage.getHeight();
        this.processedItems = 0;
        this.totalItems = this.srcHeight;
        this.horizontalSubsamplingData = this.createSubSampling(this.srcWidth, n);
        this.verticalSubsamplingData = this.createSubSampling(this.srcHeight, n2);
        int n4 = (int)Math.ceil(ResampleOpSingleThread$SubSamplingData.access$000(this.verticalSubsamplingData)) * 2;
        byte[][] byArrayArray = new byte[this.srcHeight][];
        for (n3 = 0; n3 < n4 && n3 < this.srcHeight; ++n3) {
            byArrayArray[n3] = new byte[n * this.nrChannels];
        }
        for (n3 = n4; n3 < byArrayArray.length; ++n3) {
            byArrayArray[n3] = byArrayArray[n3 % n4];
        }
        byte[][] byArrayArray2 = byArrayArray;
        BufferedImage bufferedImage3 = bufferedImage2 != null && n == bufferedImage2.getWidth() && n2 == bufferedImage2.getHeight() ? bufferedImage2 : new BufferedImage(n, n2, this.getResultBufferedImageType(bufferedImage));
        this.scale(bufferedImage, byArrayArray2, bufferedImage3);
        return bufferedImage3;
    }

    private ResampleOpSingleThread$SubSamplingData createSubSampling(int n, int n2) {
        int[] nArray;
        float[] fArray;
        int n3;
        float f2;
        float f3 = (float)n2 / (float)n;
        int[] nArray2 = new int[n2];
        float f4 = this.filter.getSamplingRadius();
        if (f3 < 1.0f) {
            f2 = f4 / f3;
            n3 = (int)(f2 * 2.0f + 2.0f);
            fArray = new float[n2 * n3];
            nArray = new int[n2 * n3];
            float f5 = (float)(1.0 / (Math.ceil(f2) / (double)f4));
            for (int i = 0; i < n2; ++i) {
                int n4;
                float f6;
                int n5;
                int n6 = i * n3;
                float f7 = (float)i / f3;
                int n7 = (int)Math.floor(f7 - f2);
                int n8 = (int)Math.ceil(f7 + f2);
                assert (n8 - n7 <= n3);
                for (n5 = n7; n5 <= n8; ++n5) {
                    f6 = this.filter.apply((f7 - (float)n5) * f5);
                    if (f6 == 0.0f) continue;
                    n4 = n5 < 0 ? -n5 : (n5 >= n ? n - n5 + n - 1 : n5);
                    int n9 = nArray2[i];
                    int n10 = i;
                    nArray2[n10] = nArray2[n10] + 1;
                    if (n4 < 0 || n4 >= n) {
                        f6 = 0.0f;
                    }
                    nArray[n6 + n9] = n4;
                    fArray[n6 + n9] = f6;
                }
                n5 = nArray2[i];
                f6 = 0.0f;
                for (n4 = 0; n4 < n5; ++n4) {
                    f6 += fArray[n6 + n4];
                }
                if (f6 == 0.0f) continue;
                for (n4 = 0; n4 < n5; ++n4) {
                    int n11 = n6 + n4;
                    fArray[n11] = fArray[n11] / f6;
                }
            }
        } else {
            f2 = f4;
            n3 = (int)(f4 * 2.0f + 1.0f);
            fArray = new float[n2 * n3];
            nArray = new int[n2 * n3];
            for (int i = 0; i < n2; ++i) {
                int n12;
                float f8;
                int n13;
                int n14 = i * n3;
                float f9 = (float)i / f3;
                int n15 = (int)Math.floor(f9 - f4);
                int n16 = (int)Math.ceil(f9 + f4);
                for (n13 = n15; n13 <= n16; ++n13) {
                    f8 = this.filter.apply(f9 - (float)n13);
                    if (f8 == 0.0f) continue;
                    n12 = n13 < 0 ? -n13 : (n13 >= n ? n - n13 + n - 1 : n13);
                    int n17 = nArray2[i];
                    int n18 = i;
                    nArray2[n18] = nArray2[n18] + 1;
                    if (n12 < 0 || n12 >= n) {
                        f8 = 0.0f;
                    }
                    nArray[n14 + n17] = n12;
                    fArray[n14 + n17] = f8;
                }
                n13 = nArray2[i];
                f8 = 0.0f;
                for (n12 = 0; n12 < n13; ++n12) {
                    f8 += fArray[n14 + n12];
                }
                assert (f8 != 0.0f) : "should never happen except bug in filter";
                if (f8 == 0.0f) continue;
                for (n12 = 0; n12 < n13; ++n12) {
                    int n19 = n14 + n12;
                    fArray[n19] = fArray[n19] / f8;
                }
            }
        }
        return new ResampleOpSingleThread$SubSamplingData(this, nArray2, nArray, fArray, n3, f2, null);
    }

    private void scale(BufferedImage bufferedImage, byte[][] byArray, BufferedImage bufferedImage2) {
        int[] nArray = new int[this.srcWidth];
        byte[] byArray2 = new byte[this.srcWidth * this.nrChannels];
        byte[] byArray3 = new byte[this.dstWidth * this.nrChannels];
        BitSet bitSet = new BitSet(this.srcHeight);
        for (int i = this.dstHeight - 1; i >= 0; --i) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = i * ResampleOpSingleThread$SubSamplingData.access$200(this.verticalSubsamplingData);
            int n7 = ResampleOpSingleThread$SubSamplingData.access$300(this.verticalSubsamplingData)[i];
            int n8 = n6;
            for (n5 = n7 - 1; n5 >= 0; --n5) {
                n4 = ResampleOpSingleThread$SubSamplingData.access$400(this.verticalSubsamplingData)[n8];
                ++n8;
                if (bitSet.get(n4)) continue;
                bitSet.set(n4);
                ImageUtils.getPixelsBGR(bufferedImage, n4, this.srcWidth, byArray2, nArray);
                for (n3 = this.nrChannels - 1; n3 >= 0; --n3) {
                    this.getSamplesHorizontal(byArray2, n3, nArray);
                    for (int j = this.dstWidth - 1; j >= 0; --j) {
                        n2 = j * this.nrChannels;
                        n = ResampleOpSingleThread$SubSamplingData.access$300(this.horizontalSubsamplingData)[j];
                        float f2 = 0.0f;
                        int n9 = j * ResampleOpSingleThread$SubSamplingData.access$200(this.horizontalSubsamplingData);
                        for (int k = n - 1; k >= 0; --k) {
                            f2 += (float)nArray[ResampleOpSingleThread$SubSamplingData.access$400(this.horizontalSubsamplingData)[n9]] * ResampleOpSingleThread$SubSamplingData.access$500(this.horizontalSubsamplingData)[n9];
                            ++n9;
                        }
                        this.putSample(byArray[n4], n3, (int)f2, n2);
                    }
                }
            }
            for (n8 = 0; n8 < this.dstWidth; ++n8) {
                n5 = n8 * this.nrChannels;
                n4 = n8 * this.nrChannels;
                for (n3 = this.nrChannels - 1; n3 >= 0; --n3) {
                    float f3 = 0.0f;
                    n2 = n6;
                    for (n = n7 - 1; n >= 0; --n) {
                        int n10 = ResampleOpSingleThread$SubSamplingData.access$400(this.verticalSubsamplingData)[n2];
                        f3 += (float)(byArray[n10][n5 + n3] & 0xFF) * ResampleOpSingleThread$SubSamplingData.access$500(this.verticalSubsamplingData)[n2];
                        ++n2;
                    }
                    this.putSample(byArray3, n3, f3, n4);
                }
            }
            ImageUtils.setBGRPixels(byArray3, bufferedImage2, 0, i, this.dstWidth, 1);
            this.setProgress(this.processedItems++, this.totalItems);
        }
    }

    private void putSample(byte[] byArray, int n, float f2, int n2) {
        int n3 = (int)f2;
        if (f2 < 0.0f) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        byArray[n2 + n] = (byte)n3;
    }

    private void getSamplesHorizontal(byte[] byArray, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        while (n3 < byArray.length) {
            nArray[n2] = byArray[n3] & 0xFF;
            n3 += this.nrChannels;
            ++n2;
        }
    }

    private void setProgress(int n, int n2) {
        this.fireProgressChanged((float)n / (float)n2);
    }

    protected int getResultBufferedImageType(BufferedImage bufferedImage) {
        return this.nrChannels == 3 ? 5 : (this.nrChannels == 4 ? 6 : (bufferedImage.getSampleModel().getDataType() == 1 ? 11 : 10));
    }
}

