/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb.device;

import com.xiaomitool.v2.adb.AdbCommons;
import com.xiaomitool.v2.adb.AdbUtils;
import com.xiaomitool.v2.adb.device.DeviceGroups;
import com.xiaomitool.v2.adb.device.DeviceProperties;
import com.xiaomitool.v2.adb.device.Properties;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.xiaomi.miuithings.SerialNumber;
import com.xiaomitool.v2.xiaomi.miuithings.UnlockStatus;
import java.io.File;
import java.util.HashMap;
import java.util.List;

class DeviceProperties$AdbProperties
extends Properties {
    final /* synthetic */ DeviceProperties this$0;

    DeviceProperties$AdbProperties(DeviceProperties deviceProperties) {
        this.this$0 = deviceProperties;
    }

    @Override
    protected boolean parseInternal() {
        this.findProps();
        this.findScreenDimension();
        this.findSu();
        this.findUnlockStatusDevice();
        this.findSerialNum();
        String string = this.get("ro.product.device", "").toString();
        if (string.isEmpty()) {
            return false;
        }
        this.findFeatures(string, false);
        return true;
    }

    private void findProps() {
        List<String> list = AdbCommons.getProps(DeviceProperties.access$000(this.this$0));
        if (list == null) {
            Log.warn("Failed to get adb device properties via getprop");
            return;
        }
        this.putAll(AdbUtils.parseGetProp(list));
    }

    private void findScreenDimension() {
        String string = AdbCommons.command("shell wm size", DeviceProperties.access$000(this.this$0));
        if (string == null) {
            Log.warn("Failed to get screen dimensions");
            return;
        }
        int[] nArray = AdbUtils.parseWmSize(string);
        if (nArray != null) {
            this.put("xmt.screen_x", nArray[0]);
            this.put("xmt.screen_y", nArray[1]);
        }
    }

    private void findSu() {
        boolean bl = false;
        bl = AdbCommons.fileExists("/system/xbin/su", DeviceProperties.access$000(this.this$0)) ? true : AdbCommons.fileExists("/system/bin/su", DeviceProperties.access$000(this.this$0));
        this.put("xmt.has_su", bl);
    }

    private void findUnlockStatusDevice() {
        this.put("xmt.lockstatus", (Object)(DeviceGroups.hasUnlockedBootloader(this.this$0.getCodename(true)) ? UnlockStatus.UNLOCKED : UnlockStatus.fromString((String)this.get("ro.secureboot.lockstate"))));
    }

    private boolean findFeatures(String string, boolean bl) {
        if (string.contains(" ")) {
            return false;
        }
        String string2 = "/system/etc/device_features/" + string + ".xml";
        if (bl) {
            File file = AdbCommons.simplePull(DeviceProperties.access$000(this.this$0), string2, "features.xml");
            if (file == null) {
                return false;
            }
            try {
                HashMap<String, String> hashMap = AdbUtils.parseFeaturesFile(file);
                if (hashMap.size() == 0) {
                    throw new Exception("returned hashmap is empty");
                }
                this.putAll(hashMap);
                return true;
            }
            catch (Exception exception) {
                Log.warn("Cannot parse features file: " + exception.getMessage());
                return false;
            }
        }
        String string3 = AdbCommons.cat(DeviceProperties.access$000(this.this$0), string2);
        if (string3 == null) {
            return this.findFeatures(string, true);
        }
        try {
            HashMap<String, String> hashMap = AdbUtils.parseFeaturesFile(string3);
            if (hashMap.size() == 0) {
                throw new Exception("Returned hashmap is empty");
            }
            this.putAll(hashMap);
            return true;
        }
        catch (Exception exception) {
            Log.warn("Cannot parse features file: " + exception.getMessage());
            return this.findFeatures(string, true);
        }
    }

    private boolean findSerialNum() {
        String string = AdbCommons.cat(DeviceProperties.access$000(this.this$0), "/proc/serial_num");
        if (string == null && (string = (String)this.get("ro.boot.cpuid", null)) == null) {
            return false;
        }
        SerialNumber serialNumber = SerialNumber.fromHexString(string);
        if (serialNumber != null) {
            this.put("xmt.serial_number", serialNumber);
            return true;
        }
        return false;
    }
}

