/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb.device;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.utility.RunnableWithArg;
import com.xiaomitool.v2.utility.WaitSemaphore;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Properties {
    private final ConcurrentHashMap<String, Object> propertiesMap = new ConcurrentHashMap();
    private final WaitSemaphore parsingSemaphore = new WaitSemaphore(1);
    private int failedParsingAttempts = 0;
    private RunnableWithArg onFailedAttemptThree = null;
    private boolean parsed = false;
    private boolean failed = false;
    private Instant lastFailIntant = null;

    public boolean isFailed() {
        return !this.parsed && this.failed;
    }

    public boolean parse() {
        return this.parse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(boolean bl) {
        boolean bl2 = false;
        WaitSemaphore waitSemaphore = this.parsingSemaphore;
        synchronized (waitSemaphore) {
            try {
                this.parsingSemaphore.decrease();
                this.parsingSemaphore.setPermits(0);
                bl2 = this.parse(bl, true);
            }
            catch (Exception exception) {
                Log.error("Failed waiting for parsing");
            }
            finally {
                this.parsingSemaphore.setPermits(1);
            }
        }
        return bl2;
    }

    public boolean parse(boolean bl, boolean bl2) {
        if (this.parsed && !bl) {
            return true;
        }
        this.parsed = true;
        if (this.failed && this.lastFailIntant != null && this.failedParsingAttempts > 3 && Duration.between(this.lastFailIntant, Instant.now()).getSeconds() < 10L) {
            Log.warn("Parsing failed more than three times less than 10 seconds ago, waiting");
            return false;
        }
        if (this.parseInternal()) {
            Log.info("Properties parsed");
            this.failedParsingAttempts = 0;
            return true;
        }
        this.lastFailIntant = Instant.now();
        this.failed = true;
        ++this.failedParsingAttempts;
        Log.warn("Failed to parse properties: " + this.toString() + ", attempt: " + this.failedParsingAttempts);
        if (this.failedParsingAttempts > 3) {
            Log.warn("Failed to parse properties for three times");
            if (this.onFailedAttemptThree != null) {
                this.onFailedAttemptThree.run(this);
            }
        }
        this.parsed = false;
        return false;
    }

    public void setOnFailedAttemptThree(RunnableWithArg runnableWithArg) {
        this.onFailedAttemptThree = runnableWithArg;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    protected abstract boolean parseInternal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object put(String string, Object object) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.propertiesMap;
        synchronized (concurrentHashMap) {
            return this.propertiesMap.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(String string) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.propertiesMap;
        synchronized (concurrentHashMap) {
            return this.propertiesMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(String string, Object object) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.propertiesMap;
        synchronized (concurrentHashMap) {
            return this.propertiesMap.getOrDefault(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putAll(Map<String, ?> map) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.propertiesMap;
        synchronized (concurrentHashMap) {
            this.propertiesMap.putAll(map);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.propertiesMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append(" -> ").append(entry.getValue()).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.propertiesMap;
        synchronized (concurrentHashMap) {
            this.parsed = false;
        }
    }

    public void set(String string, Object object) {
        this.propertiesMap.put(string, object);
    }
}

