/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.apk;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtMXSerializer;
import brut.androlib.res.util.ExtXmlSerializer;
import com.xiaomitool.v2.utility.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.xmlpull.v1.XmlPullParser;

public class ApkManifestDecoder
implements Closeable {
    private static final String DEFAULT_MANIFEST_PATH = "AndroidManifest.xml";
    private static final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    private static final String PROPERTY_SERIALIZER_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator";
    private static final String PROPERTY_DEFAULT_ENCODING = "DEFAULT_ENCODING";
    private Path zipFile;
    private FileSystem mountedFileSystem;
    private boolean isOpen = false;
    private XmlPullStreamDecoder decoder;

    public ApkManifestDecoder(String string) {
        this(Paths.get(string, new String[0]));
    }

    public ApkManifestDecoder(Path path) {
        this.zipFile = path;
    }

    public static ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer extMXSerializer = new ExtMXSerializer();
        extMXSerializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, (Object)" ");
        extMXSerializer.setProperty(PROPERTY_SERIALIZER_LINE_SEPARATOR, (Object)"\n");
        extMXSerializer.setProperty(PROPERTY_DEFAULT_ENCODING, (Object)"utf-8");
        extMXSerializer.setDisabledAttrEscape(true);
        return extMXSerializer;
    }

    public void open() {
        if (this.mountedFileSystem != null) {
            return;
        }
        this.mountedFileSystem = FileUtils.openZipFileSystem(this.zipFile, false);
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (this.mountedFileSystem == null) {
            return;
        }
        this.mountedFileSystem.close();
        this.mountedFileSystem = null;
        this.isOpen = false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private XmlPullStreamDecoder getDecoder() {
        if (this.decoder == null) {
            AXmlResourceParser aXmlResourceParser = new AXmlResourceParser();
            aXmlResourceParser.setAttrDecoder(new ResAttrDecoder());
            aXmlResourceParser.getAttrDecoder().setCurrentPackage(new ResPackage(new ResTable(), 0, null));
            this.decoder = new XmlPullStreamDecoder((XmlPullParser)aXmlResourceParser, (ExtXmlSerializer)ApkManifestDecoder.getResXmlSerializer());
        }
        return this.decoder;
    }

    public void decode(OutputStream outputStream) {
        if (!this.isOpen()) {
            throw new IOException("Closed decoder");
        }
        Path path = this.mountedFileSystem.getPath("/", new String[0]).resolve(DEFAULT_MANIFEST_PATH);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            XmlPullStreamDecoder xmlPullStreamDecoder = this.getDecoder();
            try {
                xmlPullStreamDecoder.decode((InputStream)bufferedInputStream, outputStream);
            }
            catch (AndrolibException androlibException) {
                throw new IOException("AndroidLibException: " + androlibException.getMessage(), androlibException);
            }
        }
    }
}

