/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.engine.actions;

import com.xiaomitool.v2.adb.AdbCommunication;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.adb.device.DeviceManager;
import com.xiaomitool.v2.engine.ToolManager;
import com.xiaomitool.v2.engine.actions.ActionsDynamic;
import com.xiaomitool.v2.engine.actions.ActionsStatic$1;
import com.xiaomitool.v2.engine.actions.ActionsStatic$10;
import com.xiaomitool.v2.engine.actions.ActionsStatic$11;
import com.xiaomitool.v2.engine.actions.ActionsStatic$2;
import com.xiaomitool.v2.engine.actions.ActionsStatic$3;
import com.xiaomitool.v2.engine.actions.ActionsStatic$4;
import com.xiaomitool.v2.engine.actions.ActionsStatic$5;
import com.xiaomitool.v2.engine.actions.ActionsStatic$6;
import com.xiaomitool.v2.engine.actions.ActionsStatic$7;
import com.xiaomitool.v2.engine.actions.ActionsStatic$8;
import com.xiaomitool.v2.engine.actions.ActionsStatic$9;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.raw.RawManager;
import com.xiaomitool.v2.gui.visual.ButtonPane;
import com.xiaomitool.v2.gui.visual.ErrorPane;
import com.xiaomitool.v2.gui.visual.IDClickReceiver;
import com.xiaomitool.v2.gui.visual.LoadingAnimation$WithText;
import com.xiaomitool.v2.gui.visual.TextScrollPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.logging.feedback.LiveFeedbackEasy;
import com.xiaomitool.v2.procedure.install.GenericInstall;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.DriverUtils;
import com.xiaomitool.v2.utility.RunnableMessage;
import com.xiaomitool.v2.utility.utils.InetUtils;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import com.xiaomitool.v2.utility.utils.UpdateUtils;
import com.xiaomitool.v2.utility.utils.UpdateUtils$UpdateStatus;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.apache.commons.io.FilenameUtils;

public class ActionsStatic {
    public static final String XMT_UPDATE_FILENAME = "XiaoMiTool_update.jar";

    public static RunnableMessage MAIN() {
        return () -> {
            int n = ActionsStatic.FIRST_DISCLAIMER().run();
            if (n != 1) {
                ToolManager.exit(0);
                System.exit(0);
                return 0;
            }
            LiveFeedbackEasy.sendOpen(ResourcesConst.getLogString(), null);
            Log.info("Disclaimer accepted");
            ActionsStatic.CHECK_FOR_UPDATES_V2().run();
            ActionsStatic.REQUIRE_REGION().run();
            ActionsStatic.INSTALL_DRIVERS().run();
            return ActionsStatic.MOD_CHOOSE_SCREEN().run();
        };
    }

    public static RunnableMessage OVERRIDE_UNLOCK() {
        return () -> {
            try {
                UpdateUtils.overrideUnlockOptions("https://www.xiaomitool.com/V2");
            }
            catch (Exception exception) {
                Log.error("Failed to override unlock options: " + exception.getMessage());
                Log.exc(exception);
                return 1;
            }
            return 0;
        };
    }

    public static RunnableMessage MOD_CHOOSE_SCREEN() {
        return () -> {
            RunnableMessage runnableMessage = ActionsStatic.MAIN_MOD_DEVICE();
            int n = -100;
            while (n == -100) {
                n = ActionsStatic.MOD_RECOVER_CHOICE().run();
                runnableMessage = n == 0 ? ActionsStatic.MAIN_MOD_DEVICE() : ActionsStatic.MAIN_RECOVER_DEVICE();
            }
            return runnableMessage.run();
        };
    }

    public static RunnableMessage REQUIRE_FIXANDROID() {
        return new ActionsStatic$1();
    }

    public static RunnableMessage STOP_FIXANDROID() {
        return new ActionsStatic$2();
    }

    public static RunnableMessage INSTALL_DRIVERS() {
        return () -> {
            List<Path> list;
            if (!ResourcesConst.isWindows()) {
                return 0;
            }
            AdbCommunication.killServer();
            try {
                list = ResourcesManager.getAllInfPaths();
            }
            catch (IOException iOException) {
                Log.error("Failed to find inf files: " + iOException.getMessage());
                return 1;
            }
            int n = list.size();
            if (n == 0) {
                return 1;
            }
            LoadingAnimation$WithText loadingAnimation$WithText = new LoadingAnimation$WithText("", 150.0);
            WindowManager.setMainContent((Node)loadingAnimation$WithText, false);
            int n2 = 1;
            for (Path path : list) {
                String string = FilenameUtils.getName(path.toString());
                loadingAnimation$WithText.setText(LRes.DRIVER_INSTALLING.toString(string) + " (" + n2 + "/" + n + ")");
                Log.info("Installing driver: " + path);
                boolean bl = DriverUtils.installDriver(path);
                if (bl) {
                    Log.info("Install driver success");
                } else {
                    Log.warn("Failed to install driver");
                }
                ++n2;
            }
            Thread.sleep(1500L);
            Log.info("Refreshing connected devices");
            DriverUtils.refresh();
            WindowManager.removeTopContent();
            return 0;
        };
    }

    public static RunnableMessage MAIN_MOD_DEVICE() {
        return () -> {
            ActionsDynamic.MAIN_SCREEN_LOADING(LRes.SEARCHING_CONNECTED_DEVICES).run();
            AdbCommunication.restartServer();
            AdbCommunication.registerAutoScanDevices();
            ActionsDynamic.SEARCH_SELECT_DEVICES(new Device$Status[0]).run();
            ActionsDynamic.REQUIRE_DEVICE_ON(DeviceManager.getSelectedDevice()).run();
            ActionsDynamic.FIND_DEVICE_INFO(DeviceManager.getSelectedDevice()).run();
            return 0;
        };
    }

    public static RunnableMessage FEATURE_NOT_AVAILABLE() {
        return () -> {
            Platform.runLater((Runnable)new ActionsStatic$3());
            return -100;
        };
    }

    public static RunnableMessage RESTART_ADB_SERVER() {
        return () -> {
            Log.info("Restarting adb server");
            ActionsDynamic.MAIN_SCREEN_LOADING(LRes.LOADING).run();
            AdbCommunication.restartServer();
            DeviceManager.refresh(true);
            WindowManager.removeTopContent();
            return 0;
        };
    }

    public static RunnableMessage MAIN_RECOVER_DEVICE() {
        return () -> {
            int n = ActionsStatic.RECOVERY_MODE_EXP().run();
            if (n == 0) {
                return ActionsStatic.MOD_CHOOSE_SCREEN().run();
            }
            return ActionsDynamic.START_PROCEDURE(null, GenericInstall.recoverMain(), null, GenericInstall.goBackToHome()).run();
        };
    }

    private static RunnableMessage RECOVERY_MODE_EXP() {
        return () -> {
            ButtonPane buttonPane = new ButtonPane(LRes.CANCEL, LRes.OK_UNDERSTAND);
            buttonPane.setContentText(LRes.RECOVERY_MODE_EXP);
            WindowManager.setMainContent((Node)buttonPane, false);
            int n = buttonPane.waitClick();
            WindowManager.removeTopContent(false);
            return n;
        };
    }

    public static RunnableMessage REQUIRE_INTERNET_CONNECTION() {
        return () -> {
            ActionsDynamic.MAIN_SCREEN_LOADING(LRes.LOADING).run();
            Log.info("Checking internet connection");
            boolean bl = InetUtils.isInternetAvailable();
            if (bl) {
                return -100;
            }
            ErrorPane errorPane = new ErrorPane(LRes.TRY_AGAIN);
            errorPane.setTitle(LRes.INET_CONNECTION_ERROR_TITLE);
            errorPane.setText(LRes.INET_CONNECTION_ERROR_TEXT);
            while (!bl) {
                WindowManager.setMainContent((Node)errorPane, false);
                errorPane.waitClick();
                WindowManager.removeTopContent();
                Thread.sleep(1000L);
                bl = InetUtils.isInternetAvailable();
            }
            return -100;
        };
    }

    public static RunnableMessage CHECK_FOR_UPDATES_V2() {
        return () -> {
            UpdateUtils$UpdateStatus updateUtils$UpdateStatus;
            Log.info("Action check for updates v2");
            ActionsStatic.REQUIRE_INTERNET_CONNECTION().run();
            try {
                updateUtils$UpdateStatus = UpdateUtils.checkForUpdatesV2("https://www.xiaomitool.com/V2/updateV2.php", "20.7.28", SettingsUtils.requireHashedPCId());
            }
            catch (Exception exception) {
                Log.error("Failed to check for updates: " + exception.getMessage());
                return 1;
            }
            Log.info("Update status: " + (Object)((Object)updateUtils$UpdateStatus));
            if (UpdateUtils$UpdateStatus.UPDATED.equals((Object)updateUtils$UpdateStatus)) {
                Log.info("Tool is updated");
                return 0;
            }
            boolean bl = UpdateUtils$UpdateStatus.FULL_UPDATE.equals((Object)updateUtils$UpdateStatus);
            if (UpdateUtils$UpdateStatus.QUICK_UPDATE.equals((Object)updateUtils$UpdateStatus)) {
                Log.info("Quick update available: " + updateUtils$UpdateStatus.getLatestVersion() + " - " + updateUtils$UpdateStatus.getQuickUrl());
                if (!ResourcesManager.isQuickUpdatedSupported()) {
                    bl = true;
                } else {
                    return ActionsStatic.DOWNLOAD_INSTALL_QUICK_UPDATE(updateUtils$UpdateStatus.getQuickUrl(), updateUtils$UpdateStatus.getLatestVersion(), updateUtils$UpdateStatus.getQuickSize()).run();
                }
            }
            if (bl) {
                return ActionsStatic.SHOW_UPDATE_AVAILABLE(LRes.UPDATE_AVAILABLE_TEXT.toString(new Object[]{LRes.UPDATE_FULL_UP_AVAIL, updateUtils$UpdateStatus.getLatestVersion()}), true).run();
            }
            if (UpdateUtils$UpdateStatus.BLOCK.equals((Object)updateUtils$UpdateStatus)) {
                ToolManager.exit(1);
                return -1;
            }
            Log.warn("Unknown update status: " + (Object)((Object)updateUtils$UpdateStatus));
            return 2;
        };
    }

    private static RunnableMessage SHOW_UPDATE_AVAILABLE(String string, boolean bl) {
        return new ActionsStatic$4(string, bl);
    }

    private static RunnableMessage DOWNLOAD_INSTALL_QUICK_UPDATE(String string, String string2, String string3) {
        return new ActionsStatic$5(string3, string2, string);
    }

    private static RunnableMessage QUICK_UPDATE_FAILED(String string) {
        return new ActionsStatic$6(string);
    }

    public static RunnableMessage REQUIRE_REGION() {
        return new ActionsStatic$7();
    }

    public static RunnableMessage FIRST_DISCLAIMER() {
        return () -> {
            ButtonPane buttonPane = new ButtonPane(LRes.DONT_AGREE.toString(), LRes.AGREE.toString());
            Text text = new Text(RawManager.getDisclaimer());
            text.setFont(Font.font((double)15.0));
            TextScrollPane textScrollPane = new TextScrollPane(text, LRes.DISCLAIMER.toString());
            textScrollPane.setPadding(new Insets(20.0, 100.0, 20.0, 100.0));
            buttonPane.setContent((Node)textScrollPane);
            WindowManager.setMainContent((Node)buttonPane, true);
            return buttonPane.waitClick();
        };
    }

    public static RunnableMessage MOD_RECOVER_CHOICE() {
        return () -> {
            IDClickReceiver iDClickReceiver = new IDClickReceiver();
            Platform.runLater((Runnable)new ActionsStatic$8(iDClickReceiver));
            return iDClickReceiver.waitClick() % 2;
        };
    }

    public static RunnableMessage ASK_FOR_FEEDBACK() {
        return new ActionsStatic$9();
    }

    public static RunnableMessage CLOSING() {
        return new ActionsStatic$10();
    }

    public static RunnableMessage LOAD_ONLINE_LANGS(String string) {
        return new ActionsStatic$11(string);
    }

    static /* synthetic */ RunnableMessage access$000(String string, boolean bl) {
        return ActionsStatic.SHOW_UPDATE_AVAILABLE(string, bl);
    }

    static /* synthetic */ RunnableMessage access$100(String string) {
        return ActionsStatic.QUICK_UPDATE_FAILED(string);
    }
}

