/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui;

import com.xiaomitool.v2.engine.ToolManager;
import com.xiaomitool.v2.gui.PopupWindow;
import com.xiaomitool.v2.gui.PopupWindow$Icon;
import com.xiaomitool.v2.gui.WindowManager$1;
import com.xiaomitool.v2.gui.WindowManager$2;
import com.xiaomitool.v2.gui.WindowManager$3;
import com.xiaomitool.v2.gui.WindowManager$4;
import com.xiaomitool.v2.gui.controller.DefaultController;
import com.xiaomitool.v2.gui.controller.LoginController;
import com.xiaomitool.v2.gui.controller.MainWindowController;
import com.xiaomitool.v2.gui.controller.SettingsController;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import com.xiaomitool.v2.gui.fxml.FxmlManager;
import com.xiaomitool.v2.gui.visual.OverlayPane;
import com.xiaomitool.v2.gui.visual.ToastPane;
import com.xiaomitool.v2.gui.visual.VisiblePane;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.utility.Pointer;
import com.xiaomitool.v2.utility.RunnableMessage;
import com.xiaomitool.v2.utility.SilentCompleteFuture;
import java.io.IOException;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class WindowManager {
    public static final Color XIAOMI_COLOR = Color.rgb((int)255, (int)103, (int)0);
    public static final String XIAOMI_COLOR_HEX = "FF6700";
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.rgb((int)245, (int)245, (int)245);
    public static final Background DEFAULT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)DEFAULT_BACKGROUND_COLOR, null, null)});
    public static final String FRAME_LOGIN = "LoginFrame";
    public static final String FRAME_MAIN = "MainFrame";
    public static final String FRAME_SETTINGS = "SettingsFrame";
    public static final double PREF_WIN_WIDTH = 860.0;
    public static final double PREF_WIN_HEIGHT = 860.0;
    private static final String FRAME_POPUP = "Popup";
    public static final String DEFAULT_TITLE = "XiaoMiTool V2";
    private static final Image ICON_IMAGE = DrawableManager.getResourceImage("icon.png");
    private static final DropShadow windowDropShadow = new DropShadow(10.0, 1.0, 1.0, Color.gray((double)0.7));
    private static Stage mainStage;
    private static ToastPane toastPane;
    private static OverlayPane mainOverlay;
    private static VisiblePane mainVisiblePane;
    private static MainWindowController mainWindowController;

    public static void setMainVisiblePane(VisiblePane visiblePane) {
        mainVisiblePane = visiblePane;
        mainVisiblePane.getPane().setMaxSize(860.0, 770.0);
    }

    public static void removeTopContent() {
        WindowManager.removeTopContent(true);
    }

    public static void removeTopContent(boolean bl) {
        if (mainVisiblePane == null) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            mainVisiblePane.removeTop(bl);
        } else {
            Platform.runLater(() -> mainVisiblePane.removeTop(bl));
        }
    }

    public static void setOnEmpty(Pane pane) {
        mainVisiblePane.onEmpty(pane);
    }

    public static void setMainContent(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("Cannot set null node");
        }
        if (mainVisiblePane == null) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            mainVisiblePane.saveStack(!bl);
            mainVisiblePane.add(node);
        } else {
            Platform.runLater((Runnable)new WindowManager$1(bl, node));
        }
    }

    public static void hotKey() {
        mainStage.getScene().setOnKeyPressed((EventHandler)new WindowManager$2());
    }

    public static double getContentHeight() {
        if (mainVisiblePane != null && mainVisiblePane.getPane() != null && mainVisiblePane.getPane().getHeight() > 0.0) {
            return mainVisiblePane.getPane().getHeight();
        }
        return 760.0;
    }

    public static double getContentWidth() {
        if (mainVisiblePane != null && mainVisiblePane.getPane() != null && mainVisiblePane.getPane().getWidth() > 0.0) {
            return mainVisiblePane.getPane().getWidth();
        }
        return 860.0;
    }

    public static Stage getMainStage() {
        return mainStage;
    }

    public static Pane getMainPane() {
        return mainVisiblePane.getPane();
    }

    public static Stage mainWindow() {
        return mainStage;
    }

    public static Stage launchSettings() {
        return WindowManager.launchWindow(FRAME_SETTINGS, new SettingsController());
    }

    public static Stage launchLogin() {
        return WindowManager.launchWindow(FRAME_LOGIN, new LoginController());
    }

    public static void launchMain(Stage stage, RunnableMessage runnableMessage) {
        mainStage = stage;
        mainWindowController = new MainWindowController();
        WindowManager.launchWindow(FRAME_MAIN, mainWindowController, stage);
        mainWindowController.setOnBeforeClose(runnableMessage);
        stage.setOnCloseRequest(windowEvent -> ToolManager.exit(0));
    }

    public static Stage launchWindow(String string, DefaultController defaultController) {
        return WindowManager.launchWindow(string, defaultController, null);
    }

    public static void toast(String string) {
        if (toastPane == null) {
            Log.warn("Cannot toast message: " + string);
            return;
        }
        toastPane.toast(string);
    }

    public static Stage launchPopup(PopupWindow popupWindow) {
        SilentCompleteFuture silentCompleteFuture = new SilentCompleteFuture();
        WindowManager$3 windowManager$3 = new WindowManager$3(popupWindow, silentCompleteFuture);
        if (Platform.isFxApplicationThread()) {
            windowManager$3.run();
        } else {
            Platform.runLater((Runnable)windowManager$3);
        }
        return (Stage)silentCompleteFuture.getSilently();
    }

    private static Stage launchWindow(String string, DefaultController defaultController, Stage stage) {
        return WindowManager.launchWindow(string, defaultController, stage, null);
    }

    private static void centerStage(Stage stage) {
        double d2 = mainStage.getX() + (mainStage.getWidth() - stage.getWidth()) / 2.0;
        double d3 = mainStage.getY() + (mainStage.getHeight() - stage.getHeight()) / 2.0;
        stage.setX(d2);
        stage.setY(d3);
    }

    private static Stage launchWindow(String string, DefaultController defaultController, Stage stage, Pointer<Pane> pointer) {
        boolean bl;
        boolean bl2 = bl = stage == mainStage && stage != null;
        if (bl) {
            Log.info("Launching main window");
        }
        stage = stage != null ? stage : new Stage();
        FXMLLoader fXMLLoader = new FXMLLoader(FxmlManager.getFxml(string));
        defaultController.setPrimaryStage(stage);
        fXMLLoader.setController((Object)defaultController);
        Parent parent = null;
        Parent parent2 = null;
        try {
            parent = (Parent)fXMLLoader.load();
        }
        catch (IOException iOException) {
            Log.error("Failed to load " + string + " fxml resource: " + iOException.getMessage());
            iOException.printStackTrace();
            return null;
        }
        Background background = DEFAULT_BACKGROUND;
        if (pointer != null) {
            pointer.pointed = (Pane)parent;
        }
        if (parent instanceof Pane) {
            ((Pane)parent).setBackground(background);
            if (bl) {
                mainOverlay = new OverlayPane();
                toastPane = new ToastPane(mainOverlay, 300.0, 20.0, 10.0, 100.0, 1500);
            }
        } else {
            background = null;
        }
        parent2 = parent;
        if (background != null) {
            StackPane stackPane = new StackPane(new Node[]{parent});
            if (bl) {
                stackPane.getChildren().add((Object)mainOverlay);
            }
            stackPane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0);");
            parent.setEffect((Effect)windowDropShadow);
            stackPane.setPadding(new Insets(10.0));
            parent2 = stackPane;
        }
        Scene scene = new Scene(parent2);
        if (ICON_IMAGE != null) {
            stage.getIcons().add((Object)ICON_IMAGE);
        }
        stage.setTitle(DEFAULT_TITLE);
        scene.setFill((Paint)Color.TRANSPARENT);
        if (!bl) {
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.initOwner((Window)mainStage);
        }
        stage.initStyle(StageStyle.UNDECORATED);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(scene);
        if (bl) {
            // empty if block
        }
        ToolManager.showStage(stage);
        if (!bl) {
            WindowManager.centerStage(stage);
        }
        return stage;
    }

    public static void runNowOrLater(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void popup(String string, PopupWindow$Icon popupWindow$Icon) {
        WindowManager.runNowOrLater(new WindowManager$4(string, popupWindow$Icon));
    }

    public static OverlayPane requireOverlayPane() {
        return mainOverlay;
    }

    public static Text newText(String string, boolean bl, double d2) {
        Text text = new Text(string);
        text.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        if (bl) {
            text.setTextAlignment(TextAlignment.CENTER);
        }
        text.setFont(Font.font((double)d2));
        return text;
    }

    public static Text newText(String string, boolean bl) {
        return WindowManager.newText(string, bl, 15.0);
    }

    static /* synthetic */ VisiblePane access$000() {
        return mainVisiblePane;
    }

    static /* synthetic */ Stage access$100(String string, DefaultController defaultController, Stage stage, Pointer pointer) {
        return WindowManager.launchWindow(string, defaultController, stage, pointer);
    }

    static /* synthetic */ void access$200(Stage stage) {
        WindowManager.centerStage(stage);
    }

    static {
        mainWindowController = null;
    }
}

