/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.controller;

import com.xiaomitool.v2.gui.GuiObjects;
import com.xiaomitool.v2.gui.controller.DefaultController;
import com.xiaomitool.v2.gui.controller.LoginController$1;
import com.xiaomitool.v2.gui.controller.LoginController$2;
import com.xiaomitool.v2.gui.controller.LoginController$3;
import com.xiaomitool.v2.gui.controller.LoginController$4;
import com.xiaomitool.v2.gui.visual.LoadingAnimation$WithText;
import com.xiaomitool.v2.gui.visual.TextScrollPane;
import com.xiaomitool.v2.gui.visual.VisiblePane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.utility.Pointer;
import com.xiaomitool.v2.utility.utils.CookieUtils;
import com.xiaomitool.v2.utility.utils.CookieUtils$EventCookieAdd;
import com.xiaomitool.v2.xiaomi.b;
import java.net.CookieManager;
import java.util.Locale;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class LoginController
extends DefaultController {
    private static final String LOGIN_URL = "https://account.xiaomi.com/pass/serviceLogin?sid=passport&json=false&passive=true&hidden=false&_snsDefault=facebook&_locale=" + Locale.getDefault().getLanguage().toLowerCase();
    private static boolean loggedIn = false;
    private static Thread loginThread = null;
    @FXML
    private HBox HEADER;
    @FXML
    private ImageView IMG_CLOSE;
    @FXML
    private WebView BROWSER;
    @FXML
    private Hyperlink WHY_LOGIN;
    @FXML
    private StackPane CONTENT;
    private WebEngine ENGINE;
    private VisiblePane BROWSER_AREA;
    private Node LOADING_NODE = new LoadingAnimation$WithText(LRes.LOADING, 70.0);
    private Node CURRENT_NODE;
    private String passToken = null;
    private String userId = null;
    private String deviceId = null;
    private boolean isWhyLogin = false;
    private TextScrollPane WHY_LOGIN_TEXT = null;
    private boolean loadingLocalContent = false;

    public static boolean isLogged() {
        return loggedIn;
    }

    public static void loginClick() {
        if (loggedIn) {
            LoginController.logout();
        } else {
            if (loginThread != null && loginThread.isAlive()) {
                return;
            }
            Runnable runnable = LoginController.loginRunnable();
            loginThread = new Thread(new LoginController$1(runnable));
            loginThread.start();
        }
    }

    public static void logout() {
        CookieUtils.clear();
        b.a();
        LoginController.setLoginNumber(null);
    }

    public static Runnable loginRunnable() {
        return new LoginController$2();
    }

    public static void setLoginNumber(String string) {
        Label label;
        if (string == null) {
            string = "";
        }
        if ((label = (Label)GuiObjects.getNode("login_number")) == null) {
            Log.error("Cannot set userId label: null object");
            return;
        }
        label.setText(string);
        loggedIn = !string.isEmpty();
        String string2 = loggedIn ? "Logout" : "Login";
        Hyperlink hyperlink = (Hyperlink)GuiObjects.getNode("login_link");
        if (hyperlink == null) {
            Log.error("Cannot set login hyperLink: null object");
            return;
        }
        hyperlink.setText(string2);
    }

    @Override
    protected void initialize() {
        this.setCloseImage(this.IMG_CLOSE);
        this.initHeaderDrag((Node)this.HEADER);
        this.initBrowser();
        this.initOnClick();
        this.initText();
    }

    private void initText() {
        this.WHY_LOGIN.setText(LRes.LOGIN_WHY_LOGIN.toString());
    }

    private void initOnClick() {
        this.WHY_LOGIN.setOnMouseClicked(mouseEvent -> {
            if (this.isWhyLogin) {
                this.BROWSER_AREA.add(this.CURRENT_NODE);
                this.WHY_LOGIN.setText(LRes.LOGIN_WHY_LOGIN.toString());
            } else {
                if (this.WHY_LOGIN_TEXT == null) {
                    Text text = new Text(LRes.LOGIN_WHY_LOGIN_TEXT.toString());
                    text.setFont(Font.font((double)14.0));
                    text.setTextAlignment(TextAlignment.CENTER);
                    this.WHY_LOGIN_TEXT = new TextScrollPane(text);
                    this.WHY_LOGIN_TEXT.setPadding(new Insets(30.0, 60.0, 30.0, 60.0));
                }
                this.BROWSER_AREA.add((Node)this.WHY_LOGIN_TEXT);
                this.WHY_LOGIN.setText(LRes.OK_UNDERSTAND.toString());
            }
            this.isWhyLogin = !this.isWhyLogin;
        });
    }

    private void initBrowser() {
        this.BROWSER_AREA = new VisiblePane((Pane)this.CONTENT);
        this.BROWSER_AREA.add(this.LOADING_NODE);
        this.ENGINE = this.BROWSER.getEngine();
        this.ENGINE.load(LOGIN_URL);
        Pointer pointer = new Pointer();
        pointer.pointed = new LoginController$3(this);
        CookieUtils.addCookieListener((CookieUtils$EventCookieAdd)pointer.pointed);
        this.ENGINE.getLoadWorker().stateProperty().addListener((observableValue, state, state2) -> {
            System.out.println("CM: " + CookieManager.getDefault() + " - " + CookieManager.getDefault().getClass());
            if (this.loadingLocalContent) {
                return;
            }
            if (this.BROWSER_AREA == null) {
                return;
            }
            if (Worker.State.RUNNING.equals(state2)) {
                this.setLoadingPage();
            } else if (Worker.State.FAILED.equals(state2)) {
                this.setErrorPage();
            } else if (Worker.State.SUCCEEDED.equals(state2)) {
                this.setBrowserPage();
            }
        });
    }

    private void loginDone() {
        Log.info("Logged in succesfulyl: " + this.userId);
        b.c().a(this.userId, this.passToken, this.deviceId);
        Platform.runLater((Runnable)new LoginController$4(this));
    }

    private void setLoadingPage() {
        this.CURRENT_NODE = this.LOADING_NODE;
        if (!this.isWhyLogin) {
            this.BROWSER_AREA.add(this.CURRENT_NODE);
        }
    }

    private void setErrorPage() {
        this.loadingLocalContent = true;
        this.ENGINE.loadContent("Connection error!");
        this.setBrowserPage();
        this.loadingLocalContent = false;
    }

    private void setBrowserPage() {
        this.CURRENT_NODE = this.BROWSER;
        if (!this.isWhyLogin) {
            this.BROWSER_AREA.add(this.CURRENT_NODE);
        }
    }

    static /* synthetic */ String access$002(LoginController loginController, String string) {
        loginController.passToken = string;
        return loginController.passToken;
    }

    static /* synthetic */ String access$102(LoginController loginController, String string) {
        loginController.deviceId = string;
        return loginController.deviceId;
    }

    static /* synthetic */ String access$202(LoginController loginController, String string) {
        loginController.userId = string;
        return loginController.userId;
    }

    static /* synthetic */ String access$000(LoginController loginController) {
        return loginController.passToken;
    }

    static /* synthetic */ String access$200(LoginController loginController) {
        return loginController.userId;
    }

    static /* synthetic */ String access$100(LoginController loginController) {
        return loginController.deviceId;
    }

    static /* synthetic */ void access$300(LoginController loginController) {
        loginController.loginDone();
    }
}

