/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.controller;

import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.PopupWindow;
import com.xiaomitool.v2.gui.controller.DefaultController;
import com.xiaomitool.v2.gui.controller.SettingsController$1;
import com.xiaomitool.v2.gui.controller.SettingsController$10;
import com.xiaomitool.v2.gui.controller.SettingsController$2;
import com.xiaomitool.v2.gui.controller.SettingsController$3;
import com.xiaomitool.v2.gui.controller.SettingsController$4;
import com.xiaomitool.v2.gui.controller.SettingsController$5;
import com.xiaomitool.v2.gui.controller.SettingsController$6;
import com.xiaomitool.v2.gui.controller.SettingsController$7;
import com.xiaomitool.v2.gui.controller.SettingsController$8;
import com.xiaomitool.v2.gui.controller.SettingsController$9;
import com.xiaomitool.v2.gui.visual.CustomButton;
import com.xiaomitool.v2.gui.visual.OverlayPane;
import com.xiaomitool.v2.gui.visual.ToastPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.language.Lang;
import com.xiaomitool.v2.utility.Pair;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import com.xiaomitool.v2.utility.utils.SettingsUtils$Region;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class SettingsController
extends DefaultController {
    private static final OverlayPane settingsOverlayPane = new OverlayPane();
    private static final ToastPane settingsToastPane = new ToastPane(settingsOverlayPane);
    private static PopupWindow feedbackPopup;
    @FXML
    private ImageView IMG_CLOSE;
    @FXML
    private HBox HEADER;
    @FXML
    private Label LABEL_DOWNLOAD;
    @FXML
    private Label LABEL_EXTRACT;
    @FXML
    private Label TEXT_DOWNLOAD;
    @FXML
    private Label TEXT_EXTRACT;
    @FXML
    private Button BUTTON_DOWNLOAD;
    @FXML
    private Button BUTTON_EXTRACT;
    @FXML
    private Button BUTTON_CLEAR;
    @FXML
    private Button BUTTON_RESET;
    @FXML
    private Button BUTTON_FEEDBACK;
    @FXML
    private CheckBox CHECK_SAVE_LOGIN;
    @FXML
    private StackPane WHOLE;
    @FXML
    private ComboBox<String> REGION_COMBO;
    @FXML
    private ComboBox<String> LANG_COMBO;
    private List<Pair<String, String>> langEntries;

    public static PopupWindow getFeedbackPopupWindow() {
        if (feedbackPopup == null) {
            feedbackPopup = new PopupWindow(500.0, 400.0);
            Text text = new Text(LRes.SEND_FEEDBACK.toString());
            text.setFont(Font.font((double)20.0));
            TextArea textArea = new TextArea();
            textArea.setPrefHeight(180.0);
            textArea.setFont(Font.font((double)14.0));
            textArea.setPromptText("Please explain your problem here.\r\nWrite in English or leave blank if you just want to send the log.\r\n" + LRes.FEEDBACK_ONLY_ONE.toEnglish());
            textArea.setTextFormatter(new TextFormatter(change -> change.getControlNewText().length() <= 500 ? change : null));
            CustomButton customButton = new CustomButton(LRes.SEND_FEEDBACK);
            customButton.setFont(Font.font((double)15.0));
            textArea.setFocusTraversable(false);
            CheckBox checkBox = new CheckBox(LRes.INCLUDE_LOG_FILES.toString());
            checkBox.setSelected(true);
            checkBox.setFont(Font.font((double)15.0));
            VBox vBox = new VBox(18.0, new Node[]{text, textArea, checkBox, customButton});
            HBox hBox = new HBox(20.0, new Node[]{new Pane(), vBox, new Pane()});
            hBox.setAlignment(Pos.CENTER);
            vBox.setAlignment(Pos.CENTER);
            feedbackPopup.setContent((Node)hBox);
            customButton.setOnAction(new SettingsController$1(textArea, checkBox, customButton));
        }
        return feedbackPopup;
    }

    @Override
    protected void initialize() {
        this.setCloseImage(this.IMG_CLOSE);
        this.initHeaderDrag((Node)this.HEADER);
        this.initCss();
        this.initTexts();
        this.loadSettings();
        this.initOnClick();
        this.WHOLE.getChildren().add((Object)settingsOverlayPane);
    }

    private void initCss() {
        this.TEXT_EXTRACT.setStyle("-fx-text-overrun: leading-ellipsis;");
        this.TEXT_DOWNLOAD.setStyle("-fx-text-overrun: leading-ellipsis;");
        this.BUTTON_CLEAR.setDisable(true);
        GuiUtils.specialComboBox(this.REGION_COMBO, LRes.SELECTED_REGION, 14);
        GuiUtils.specialComboBox(this.LANG_COMBO, LRes.SELECTED_LANG, 14);
    }

    private void initTexts() {
        this.LABEL_DOWNLOAD.setText(LRes.SETTINGS_DOWNLOAD_DIR.toString());
        this.LABEL_EXTRACT.setText(LRes.SETTINGS_EXTRACT_DIR.toString());
        this.BUTTON_DOWNLOAD.setText(LRes.CHOOSE.toString());
        this.BUTTON_CLEAR.setText(LRes.SETTINGS_CLEAR.toString());
        this.BUTTON_RESET.setText(LRes.SETTINGS_RESET.toString());
        this.BUTTON_EXTRACT.setText(LRes.CHOOSE.toString());
        this.CHECK_SAVE_LOGIN.setText(LRes.SETTINGS_SAVE_SESSION.toString());
        this.BUTTON_FEEDBACK.setText(LRes.SEND_FEEDBACK.toString());
        this.REGION_COMBO.setPromptText(LRes.PLEASE_SELECT_REGION.toString());
        this.REGION_COMBO.setItems((ObservableList)new SettingsController$2(this));
        this.langEntries = Lang.getComboChoices();
        this.LANG_COMBO.setPromptText(LRes.PLEASE_SELECT_LANGUAGE.toString());
        this.LANG_COMBO.setItems((ObservableList)new SettingsController$3(this));
    }

    private void loadSettings() {
        String string;
        String string2;
        SettingsUtils.load();
        Path path = SettingsUtils.getDownloadPath();
        Path path2 = SettingsUtils.getExtractPath();
        try {
            string2 = path.toFile().getCanonicalPath();
            string = path2.toFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = path.toString();
            string = path2.toString();
        }
        this.TEXT_DOWNLOAD.setText(string2);
        this.TEXT_EXTRACT.setText(string);
        String string3 = SettingsUtils.getOpt("pref_save_session");
        boolean bl = "true".equalsIgnoreCase(string3);
        this.CHECK_SAVE_LOGIN.setSelected(bl);
    }

    private void initOnClick() {
        SettingsUtils$Region settingsUtils$Region = SettingsUtils.getRegion();
        if (settingsUtils$Region != null) {
            int n = 0;
            for (SettingsUtils$Region settingsUtils$Region2 : SettingsUtils$Region.values()) {
                if (settingsUtils$Region.equals((Object)settingsUtils$Region2)) {
                    this.REGION_COMBO.getSelectionModel().select(n);
                }
                ++n;
            }
        }
        this.REGION_COMBO.setOnAction((EventHandler)new SettingsController$4(this));
        String string = SettingsUtils.getLanguage();
        if (this.langEntries != null && string != null) {
            int n = 0;
            for (Pair<String, String> pair : this.langEntries) {
                if (string.equals(pair.getFirst())) {
                    this.LANG_COMBO.getSelectionModel().select(n);
                    break;
                }
                ++n;
            }
        }
        this.LANG_COMBO.setOnAction((EventHandler)new SettingsController$5(this));
        this.BUTTON_EXTRACT.setOnAction((EventHandler)new SettingsController$6(this));
        this.BUTTON_DOWNLOAD.setOnAction((EventHandler)new SettingsController$7(this));
        this.CHECK_SAVE_LOGIN.setOnAction((EventHandler)new SettingsController$8(this));
        this.BUTTON_FEEDBACK.setOnAction((EventHandler)new SettingsController$9(this));
        this.BUTTON_RESET.setOnAction((EventHandler)new SettingsController$10(this));
    }

    static /* synthetic */ PopupWindow access$000() {
        return feedbackPopup;
    }

    static /* synthetic */ ToastPane access$100() {
        return settingsToastPane;
    }

    static /* synthetic */ List access$200(SettingsController settingsController) {
        return settingsController.langEntries;
    }

    static /* synthetic */ ComboBox access$300(SettingsController settingsController) {
        return settingsController.REGION_COMBO;
    }

    static /* synthetic */ ComboBox access$400(SettingsController settingsController) {
        return settingsController.LANG_COMBO;
    }

    static /* synthetic */ Label access$500(SettingsController settingsController) {
        return settingsController.TEXT_EXTRACT;
    }

    static /* synthetic */ Label access$600(SettingsController settingsController) {
        return settingsController.TEXT_DOWNLOAD;
    }

    static /* synthetic */ CheckBox access$700(SettingsController settingsController) {
        return settingsController.CHECK_SAVE_LOGIN;
    }
}

