/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.deviceView.Animatable$AnimationPayload;
import com.xiaomitool.v2.gui.deviceView.AnimatableDeviceView;
import com.xiaomitool.v2.gui.deviceView.DeviceView;
import com.xiaomitool.v2.gui.visual.ButtonPane;
import com.xiaomitool.v2.gui.visual.CustomButton;
import com.xiaomitool.v2.gui.visual.DeviceImgInstructionPane$1;
import com.xiaomitool.v2.gui.visual.DeviceImgInstructionPane$2;
import com.xiaomitool.v2.gui.visual.DeviceImgInstructionPane$3;
import com.xiaomitool.v2.gui.visual.IDClickReceiver;
import com.xiaomitool.v2.gui.visual.OverlayPane;
import com.xiaomitool.v2.gui.visual.SidePane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import java.util.HashMap;
import java.util.List;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class DeviceImgInstructionPane
extends SidePane {
    private String[] texts;
    private Image[] images;
    private HashMap<Integer, Animatable$AnimationPayload> animations;
    private int index = 0;
    private Button prevButton;
    private Button nextButton;
    private Text instructionText;
    private AnimatableDeviceView deviceView;
    private ButtonPane closeButtonPane;
    private Transition currentAnimation = null;

    public DeviceImgInstructionPane(double d2, double d3, String[] stringArray, Image[] imageArray, HashMap<Integer, Animatable$AnimationPayload> hashMap) {
        this.texts = stringArray;
        this.images = imageArray;
        this.animations = hashMap;
        this.build(d2, d3);
    }

    private void build(double d2, double d3) {
        if (this.texts == null || this.images == null || this.texts.length != this.images.length || this.texts.length == 0) {
            throw new IllegalArgumentException("Please, pass not null, not empty arrays with same num of elements");
        }
        ButtonPane buttonPane = new ButtonPane(LRes.PREV_STEP, LRes.NEXT_STEP);
        this.closeButtonPane = new ButtonPane(LRes.OK_FINISHED);
        List<CustomButton> list = buttonPane.getButtons();
        this.prevButton = list.get(0);
        this.nextButton = list.get(1);
        this.prevButton.setDisable(true);
        this.instructionText = new Text();
        this.instructionText.setWrappingWidth(400.0);
        this.instructionText.setFont(Font.font((double)15.0));
        this.instructionText.setTextAlignment(TextAlignment.CENTER);
        buttonPane.setContent((Node)this.instructionText);
        this.deviceView = new DeviceImgInstructionPane$1(this, DeviceView.DEVICE_18_9, d2);
        this.deviceView.setContent(this.images[this.index]);
        buttonPane.getIdClickReceiver().addListener(new DeviceImgInstructionPane$2(this));
        this.closeButtonPane.setContent((Node)buttonPane);
        StackPane stackPane = new StackPane(new Node[]{this.closeButtonPane});
        stackPane.setPadding(new Insets(20.0, 0.0, 30.0, 20.0));
        this.loadStep();
        this.setLeft((Node)stackPane);
        this.setRight((Node)GuiUtils.center((Node)DeviceView.crop(this.deviceView, d2, d2 > d3 ? (d2 - d3) / 2.0 : 0.0)));
    }

    public void animate() {
        this.deviceView.animate(this.index);
    }

    public void setOverlayLen(OverlayPane overlayPane, double d2) {
        DeviceImgInstructionPane$3 deviceImgInstructionPane$3 = new DeviceImgInstructionPane$3(this, overlayPane, d2);
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)deviceImgInstructionPane$3);
        } else {
            deviceImgInstructionPane$3.run();
        }
    }

    private void loadStep() {
        Image image = this.images[this.index];
        String string = LRes.STEP.toString() + " [" + (this.index + 1) + "/" + this.texts.length + "]:\n" + this.texts[this.index];
        if (this.index == 0) {
            this.prevButton.setDisable(true);
        } else {
            this.prevButton.setDisable(false);
        }
        if (this.index == this.texts.length - 1) {
            this.nextButton.setDisable(true);
        } else {
            this.nextButton.setDisable(false);
        }
        this.instructionText.setText(string);
        this.deviceView.setContent(image);
        try {
            this.animate();
        }
        catch (InterruptedException interruptedException) {
            Log.warn("Animation error: " + interruptedException.getMessage());
        }
    }

    public int waitClick() {
        return this.closeButtonPane.waitClick();
    }

    public IDClickReceiver getIdClickReceiver() {
        return this.closeButtonPane.getIdClickReceiver();
    }

    static /* synthetic */ HashMap access$000(DeviceImgInstructionPane deviceImgInstructionPane) {
        return deviceImgInstructionPane.animations;
    }

    static /* synthetic */ Transition access$102(DeviceImgInstructionPane deviceImgInstructionPane, Transition transition) {
        deviceImgInstructionPane.currentAnimation = transition;
        return deviceImgInstructionPane.currentAnimation;
    }

    static /* synthetic */ AnimatableDeviceView access$200(DeviceImgInstructionPane deviceImgInstructionPane) {
        return deviceImgInstructionPane.deviceView;
    }

    static /* synthetic */ int access$300(DeviceImgInstructionPane deviceImgInstructionPane) {
        return deviceImgInstructionPane.index;
    }

    static /* synthetic */ String[] access$400(DeviceImgInstructionPane deviceImgInstructionPane) {
        return deviceImgInstructionPane.texts;
    }

    static /* synthetic */ int access$310(DeviceImgInstructionPane deviceImgInstructionPane) {
        return deviceImgInstructionPane.index--;
    }

    static /* synthetic */ int access$308(DeviceImgInstructionPane deviceImgInstructionPane) {
        return deviceImgInstructionPane.index++;
    }

    static /* synthetic */ void access$500(DeviceImgInstructionPane deviceImgInstructionPane) {
        deviceImgInstructionPane.loadStep();
    }
}

