/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.utility.BezierInterpolator$WaitBezierInterpolator;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

public class LoadingAnimation
extends StackPane {
    private long duration = 2000L;
    private double animationWidth = 200.0;
    private double circleRadius = 5.0;
    private Color color = WindowManager.XIAOMI_COLOR;
    private double circleNumber = 5.0;
    private double easeParameter = 0.7;

    public LoadingAnimation() {
        this.build();
    }

    public LoadingAnimation(double d2) {
        this.animationWidth = d2;
        this.circleRadius = d2 / 45.0 + 2.0;
        this.build();
    }

    public double getCircleRadius() {
        return this.circleRadius;
    }

    private Transition buildTransition(Node node) {
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)this.duration), node);
        translateTransition.setFromX(-1.0 * this.animationWidth);
        translateTransition.setToX(this.animationWidth);
        translateTransition.setAutoReverse(false);
        translateTransition.setCycleCount(-1);
        double d2 = 0.07 + this.circleNumber * 0.04;
        translateTransition.setInterpolator((Interpolator)new BezierInterpolator$WaitBezierInterpolator(0.0, this.easeParameter, 1.0 - this.easeParameter, 1.0, d2, d2));
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)(this.duration / 2L)), node);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.setAutoReverse(true);
        fadeTransition.setCycleCount(-1);
        fadeTransition.setInterpolator((Interpolator)new BezierInterpolator$WaitBezierInterpolator(0.0, this.easeParameter, 1.0, 1.0, 2.0 * d2, 0.0));
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)(this.duration / 2L)), node);
        scaleTransition.setFromX(0.6);
        scaleTransition.setFromY(0.6);
        scaleTransition.setToX(1.4);
        scaleTransition.setToY(1.4);
        scaleTransition.setAutoReverse(true);
        scaleTransition.setCycleCount(-1);
        scaleTransition.setInterpolator((Interpolator)new BezierInterpolator$WaitBezierInterpolator(0.0, this.easeParameter, 1.0, 1.0, 2.0 * d2, 0.0));
        return new ParallelTransition(new Animation[]{translateTransition, fadeTransition, scaleTransition});
    }

    private Circle buildCircle() {
        Circle circle = new Circle(this.circleRadius, (Paint)this.color);
        circle.setOpacity(0.0);
        return circle;
    }

    private void build() {
        ParallelTransition parallelTransition = new ParallelTransition();
        int n = 0;
        while ((double)n < this.circleNumber) {
            Circle circle = this.buildCircle();
            Transition transition = this.buildTransition((Node)circle);
            transition.setDelay(Duration.millis((double)((long)n * this.duration / 10L)));
            parallelTransition.getChildren().add((Object)transition);
            super.getChildren().add((Object)circle);
            ++n;
        }
        parallelTransition.play();
    }

    public long getDuration() {
        return this.duration;
    }

    public double getAnimationWidth() {
        return this.animationWidth;
    }
}

