/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ProgressPane
extends VBox {
    protected StackPane content;
    protected StackPane overBar;
    protected ProgressBar progress;

    public ProgressPane() {
        this.build();
    }

    private void build() {
        this.content = new StackPane();
        this.progress = new ProgressBar(0.0);
        this.overBar = new StackPane();
        VBox vBox = new VBox(new Node[]{this.overBar, this.progress});
        vBox.setSpacing(10.0);
        vBox.setAlignment(Pos.CENTER);
        StackPane stackPane = new StackPane(new Node[]{vBox});
        super.getChildren().addAll((Object[])new Node[]{this.content, stackPane});
        super.setAlignment(Pos.CENTER);
        super.setSpacing(10.0);
    }

    public void setContent(Node node) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.setContent(node));
            return;
        }
        this.content.getChildren().clear();
        this.content.getChildren().add((Object)node);
    }

    public void setProgress(Double d2) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.setProgress(d2));
            return;
        }
        if (d2 >= 0.0 && d2 <= 1.0) {
            this.progress.setProgress(d2.doubleValue());
        } else {
            this.progress.setProgress(-1.0);
        }
    }

    public void setOverBar(Node node) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.setOverBar(node));
            return;
        }
        this.overBar.getChildren().clear();
        this.overBar.getChildren().add((Object)node);
    }
}

