/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.visual.SortableTableView$1;
import com.xiaomitool.v2.gui.visual.SortableTableView$2;
import com.xiaomitool.v2.gui.visual.SortableTableView$TableViewColumn;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class SortableTableView<S>
extends TableView<S> {
    private static final DataFormat SERIALIZED_MIME_TYPE = new DataFormat(new String[]{"application/x-java-serialized-object"});

    public SortableTableView(SortableTableView$TableViewColumn<S> ... sortableTableView$TableViewColumnArray) {
        ObservableList observableList = this.getColumns();
        for (SortableTableView$TableViewColumn<S> sortableTableView$TableViewColumn : sortableTableView$TableViewColumnArray) {
            observableList.add(SortableTableView.createCol(SortableTableView$TableViewColumn.access$000(sortableTableView$TableViewColumn), SortableTableView$TableViewColumn.access$100(sortableTableView$TableViewColumn), SortableTableView$TableViewColumn.access$200(sortableTableView$TableViewColumn)));
        }
        this.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.setFocusTraversable(false);
        this.focusedProperty().addListener((ChangeListener)new SortableTableView$1(this));
        this.setRowFactory(tableView -> {
            TableRow tableRow = new TableRow();
            tableRow.setOnDragDetected(mouseEvent -> {
                if (!tableRow.isEmpty()) {
                    Integer n = tableRow.getIndex();
                    Dragboard dragboard = tableRow.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    dragboard.setDragView((Image)tableRow.snapshot(null, null));
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.put((Object)SERIALIZED_MIME_TYPE, (Object)n);
                    dragboard.setContent((Map)clipboardContent);
                    mouseEvent.consume();
                }
            });
            tableRow.setOnMouseClicked((EventHandler)new SortableTableView$2(this, tableRow));
            tableRow.setOnDragOver(dragEvent -> {
                Dragboard dragboard = dragEvent.getDragboard();
                if (dragboard.hasContent(SERIALIZED_MIME_TYPE) && tableRow.getIndex() != ((Integer)dragboard.getContent(SERIALIZED_MIME_TYPE)).intValue()) {
                    dragEvent.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                    dragEvent.consume();
                }
            });
            tableRow.setOnDragDropped(dragEvent -> {
                Dragboard dragboard = dragEvent.getDragboard();
                if (dragboard.hasContent(SERIALIZED_MIME_TYPE)) {
                    int n = (Integer)dragboard.getContent(SERIALIZED_MIME_TYPE);
                    Object object = this.getItems().remove(n);
                    int n2 = tableRow.isEmpty() ? this.getItems().size() : tableRow.getIndex();
                    this.getItems().add(n2, object);
                    dragEvent.setDropCompleted(true);
                    this.getSelectionModel().select(n2);
                    dragEvent.consume();
                }
            });
            return tableRow;
        });
    }

    private static <T> TableColumn<T, String> createCol(String string, Function<T, ObservableValue<String>> function, Double d2) {
        TableColumn tableColumn = new TableColumn(string);
        tableColumn.setCellValueFactory(cellDataFeatures -> (ObservableValue)function.apply(cellDataFeatures.getValue()));
        if (d2 != null) {
            tableColumn.setPrefWidth(d2.doubleValue());
        }
        tableColumn.setSortable(false);
        return tableColumn;
    }
}

