/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.TextScrollPane$1;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class TextScrollPane
extends StackPane {
    private Color bgColor = WindowManager.DEFAULT_BACKGROUND_COLOR;

    public TextScrollPane(Text text) {
        this.build(text, null);
    }

    public TextScrollPane(Text text, String string) {
        this.build(text, string);
    }

    public TextScrollPane(Color color, Text text, String string) {
        this.bgColor = color;
        this.build(text, string);
    }

    private void build(Text text, String string) {
        VBox vBox;
        Text text2;
        ScrollPane scrollPane = new ScrollPane();
        text.wrappingWidthProperty().bind((ObservableValue)scrollPane.widthProperty().subtract(20));
        scrollPane.setFitToWidth(true);
        if (string == null) {
            text2 = text;
        } else {
            vBox = new VBox();
            vBox.setAlignment(Pos.CENTER);
            vBox.setSpacing(10.0);
            vBox.getChildren().addAll((Object[])new Node[]{this.buildTitle(string), text});
            text2 = vBox;
        }
        vBox = new StackPane(new Node[]{text2});
        vBox.prefHeightProperty().bind((ObservableValue)Bindings.createObjectBinding((Callable)new TextScrollPane$1(this, scrollPane), (Observable[])new Observable[]{scrollPane.viewportBoundsProperty()}));
        scrollPane.setContent((Node)vBox);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setStyle("-fx-background: rgba(245,245,245,0); -fx-background-color: rgba(245,245,245,0);");
        super.setBackground(GuiUtils.backgroundFromColor((Paint)Color.TRANSPARENT));
        super.getChildren().add((Object)scrollPane);
    }

    private Label buildTitle(String string) {
        Label label = new Label(string);
        label.setFont(Font.font(null, (FontWeight)FontWeight.SEMI_BOLD, (double)20.0));
        label.setPrefHeight(40.0);
        label.setTextAlignment(TextAlignment.CENTER);
        return label;
    }
}

