/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.visual.OverlayPane;
import com.xiaomitool.v2.gui.visual.ToastPane$1;
import com.xiaomitool.v2.gui.visual.ToastPane$2;
import com.xiaomitool.v2.utility.Pointer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class ToastPane {
    private static final Background TOAST_BACK = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.gray((double)0.8), new CornerRadii(20.0), null)});
    private static final Border TOAST_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.gray((double)0.3), BorderStrokeStyle.SOLID, new CornerRadii(20.0), BorderStroke.THIN)});
    private double TOAST_WIDTH = 200.0;
    private int TOAST_DURATION = 3000;
    private double TOAST_RADIUS = 20.0;
    private double TOAST_SPACING = 10.0;
    private double TOAST_OFFSET;
    private double lowHeight = this.TOAST_OFFSET = 0.0;
    private OverlayPane overlayPane;

    public ToastPane(OverlayPane overlayPane, double d2, double d3, double d4, double d5, int n) {
        this(overlayPane);
        this.TOAST_RADIUS = d3;
        this.TOAST_WIDTH = d2;
        this.TOAST_SPACING = d4;
        this.TOAST_DURATION = n;
        this.TOAST_OFFSET = d5;
        this.lowHeight = d5;
    }

    public ToastPane(OverlayPane overlayPane) {
        this.overlayPane = overlayPane;
    }

    public void toast(String string) {
        this.lowHeight += this.TOAST_SPACING + this.TOAST_RADIUS;
        Text text = new Text(string);
        StackPane stackPane = new StackPane(new Node[]{text});
        stackPane.setPickOnBounds(false);
        double d2 = text.getLayoutBounds().getHeight();
        stackPane.setBackground(TOAST_BACK);
        stackPane.setPrefWidth(this.TOAST_WIDTH);
        stackPane.setPadding(new Insets(this.TOAST_RADIUS / 2.0));
        stackPane.setLayoutX((this.overlayPane.getWidth() - this.TOAST_WIDTH) / 2.0);
        this.lowHeight += d2;
        Pointer pointer = new Pointer();
        pointer.pointed = this.lowHeight;
        stackPane.setLayoutY(this.overlayPane.getHeight() - this.lowHeight);
        stackPane.setBorder(TOAST_BORDER);
        this.overlayPane.getChildren().add((Object)stackPane);
        for (Transition transition : this.getTransitions((Pane)stackPane)) {
            if (transition instanceof FadeTransition) {
                transition.setOnFinished((EventHandler)new ToastPane$1(this, stackPane, pointer));
            }
            transition.play();
        }
    }

    private Pane getParentPane() {
        return this.overlayPane;
    }

    private Transition[] getTransitions(Pane pane) {
        ToastPane$2 toastPane$2 = new ToastPane$2(this);
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)(this.TOAST_DURATION / 2)), (Node)pane);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(0.75);
        fadeTransition.setCycleCount(2);
        fadeTransition.setAutoReverse(true);
        fadeTransition.setInterpolator((Interpolator)toastPane$2);
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)(this.TOAST_DURATION / 2)), (Node)pane);
        translateTransition.setFromY(15.0);
        translateTransition.setToY(0.0);
        translateTransition.setCycleCount(2);
        translateTransition.setAutoReverse(true);
        translateTransition.setInterpolator((Interpolator)toastPane$2);
        return new Transition[]{fadeTransition, translateTransition};
    }

    static /* synthetic */ Pane access$000(ToastPane toastPane) {
        return toastPane.getParentPane();
    }

    static /* synthetic */ double access$100(ToastPane toastPane) {
        return toastPane.lowHeight;
    }

    static /* synthetic */ double access$102(ToastPane toastPane, double d2) {
        toastPane.lowHeight = d2;
        return toastPane.lowHeight;
    }

    static /* synthetic */ double access$200(ToastPane toastPane) {
        return toastPane.TOAST_OFFSET;
    }
}

