/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.logging.Log;
import java.util.Collection;
import java.util.LinkedList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class VisiblePane {
    private final LinkedList<Node> children = new LinkedList();
    private final LinkedList<Node> removeBuffer = new LinkedList();
    private Pane pane;
    private boolean keepStack = false;
    private Pane onEmpty;

    public VisiblePane() {
        this(null);
    }

    public VisiblePane(Pane pane) {
        if (pane == null) {
            pane = new StackPane();
        } else {
            this.children.addAll((Collection<Node>)pane.getChildren());
        }
        this.pane = pane;
    }

    public void add(Node node) {
        this.set(node, true);
    }

    public void addHidden(Node node) {
        this.set(node, false);
    }

    public void saveStack(boolean bl) {
        this.keepStack = bl;
    }

    public void removeTop() {
        this.removeTop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRemoveBuffer() {
        LinkedList<Node> linkedList = this.removeBuffer;
        synchronized (linkedList) {
            for (Node node : this.removeBuffer) {
                this.removeLayer(node);
            }
            this.removeBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLayer(Node node) {
        Pane pane = null;
        try {
            LinkedList<Node> linkedList = this.children;
            synchronized (linkedList) {
                node.setVisible(false);
                this.pane.getChildren().remove((Object)node);
                node = this.children.getLast();
                if (node != null) {
                    node.setVisible(true);
                } else if (this.onEmpty != null) {
                    pane = this.onEmpty;
                }
            }
        }
        catch (Exception exception) {
            pane = this.onEmpty;
        }
        if (pane != null) {
            this.add((Node)pane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTop(boolean bl) {
        block11: {
            if (bl) {
                this.clearRemoveBuffer();
            }
            try {
                Node node = this.children.getLast();
                if (node == null) {
                    return;
                }
                LinkedList<Node> linkedList = this.children;
                synchronized (linkedList) {
                    this.children.remove(node);
                }
                if (bl) {
                    this.removeLayer(node);
                    break block11;
                }
                linkedList = this.removeBuffer;
                synchronized (linkedList) {
                    this.removeBuffer.add(node);
                }
            }
            catch (Exception exception) {
                Log.exc(exception);
            }
        }
    }

    public Pane getPane() {
        return this.pane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Node node, boolean bl) {
        this.clearRemoveBuffer();
        LinkedList<Node> linkedList = this.children;
        synchronized (linkedList) {
            if (!this.keepStack && bl) {
                this.children.clear();
                this.pane.getChildren().clear();
            }
            if (!this.children.contains(node)) {
                this.children.add(node);
                node.setPickOnBounds(false);
                this.pane.getChildren().add((Object)node);
            }
            if (this.keepStack) {
                if (bl) {
                    for (Node node2 : this.children) {
                        node2.setVisible(false);
                    }
                    node.setVisible(true);
                } else {
                    node.setVisible(false);
                }
            }
        }
    }

    public void remove(Node node) {
        this.children.remove(node);
        this.pane.getChildren().remove((Object)node);
    }

    public void clear() {
        this.children.clear();
        this.pane.getChildren().clear();
    }

    public void onEmpty(Pane pane) {
        this.onEmpty = this.onEmpty;
    }
}

