/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.inet;

import com.xiaomitool.v2.inet.CustomHttpException;
import com.xiaomitool.v2.inet.CustomHttpRequest$Type;
import com.xiaomitool.v2.inet.HttpQuery;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.utility.MultiMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.config.RequestConfig$Builder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class CustomHttpRequest {
    public static final SSLContext TLS12;
    private CustomHttpRequest$Type requestType = CustomHttpRequest$Type.GET;
    private LinkedHashMap<String, String> headers;
    private HttpQuery postParams;
    private String proxyHost;
    private int proxyPort = -1;
    private String url;
    private HttpResponse response;
    private HttpRequest request;
    private byte[] postData;
    private InputStream postInputStream;

    public CustomHttpRequest() {
        this(null);
    }

    public CustomHttpRequest(String string) {
        this.url = string;
        this.headers = new LinkedHashMap();
    }

    private static HttpResponse execRequest(HttpClientBuilder httpClientBuilder, HttpUriRequest httpUriRequest) {
        return CustomHttpRequest.execRequest(httpClientBuilder, httpUriRequest, false);
    }

    private static HttpResponse execRequest(HttpClientBuilder httpClientBuilder, HttpUriRequest httpUriRequest, boolean bl) {
        if (bl && TLS12 != null) {
            httpClientBuilder.setSSLContext(TLS12);
        }
        try {
            return httpClientBuilder.build().execute(httpUriRequest);
        }
        catch (ClientProtocolException clientProtocolException) {
            throw new CustomHttpException("ClientProtocolException: " + clientProtocolException.getMessage(), clientProtocolException);
        }
        catch (IOException iOException) {
            if (bl || !(iOException instanceof SSLHandshakeException)) {
                throw new CustomHttpException("IOException: " + iOException.getMessage(), iOException);
            }
            return CustomHttpRequest.execRequest(httpClientBuilder, httpUriRequest, true);
        }
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setProxy(String string, int n) {
        this.proxyPort = n;
        this.proxyHost = string;
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public void addHeaders(Map<String, String> map) {
        this.headers.putAll(map);
    }

    public void addPostField(String string, String string2) {
        this.makeItPost();
        this.postParams.put(string, (Object)string2);
    }

    public void addPostFields(Map<String, ?> map) {
        this.makeItPost();
        this.postParams.putAll(map);
    }

    public void setPostData(byte[] byArray) {
        this.makeItPost();
        this.postData = byArray;
    }

    public void setPostData(InputStream inputStream) {
        this.makeItPost();
        this.postInputStream = inputStream;
    }

    private void makeItPost() {
        if (this.requestType.equals((Object)CustomHttpRequest$Type.POST)) {
            return;
        }
        this.postParams = new HttpQuery();
        this.requestType = CustomHttpRequest$Type.POST;
    }

    public void execute() {
        HttpRequestBase httpRequestBase;
        Cloneable cloneable;
        if (this.url == null) {
            throw new CustomHttpException("Missing request url");
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig$Builder requestConfig$Builder = RequestConfig.custom();
        if (this.proxyPort > -1) {
            cloneable = new HttpHost(this.proxyHost, this.proxyPort);
            requestConfig$Builder = requestConfig$Builder.setProxy((HttpHost)cloneable);
        }
        requestConfig$Builder.setRedirectsEnabled(false);
        cloneable = requestConfig$Builder.build();
        if (this.requestType.equals((Object)CustomHttpRequest$Type.POST)) {
            httpRequestBase = new HttpPost(this.url);
            if (this.postData != null) {
                ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity(new ByteArrayEntity(this.postData));
            } else if (this.postInputStream != null) {
                ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity(new InputStreamEntity(this.postInputStream));
            } else {
                LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
                for (Map.Entry entry : this.postParams.entrySet()) {
                    linkedList.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue().toString()));
                }
                ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity(new UrlEncodedFormEntity(linkedList, ResourcesConst.interalCharset()));
            }
        } else if (this.requestType.equals((Object)CustomHttpRequest$Type.GET)) {
            httpRequestBase = new HttpGet(this.url);
        } else if (this.requestType.equals((Object)CustomHttpRequest$Type.HEAD)) {
            httpRequestBase = new HttpHead(this.url);
        } else {
            throw new CustomHttpException("Unknown request type: " + (Object)((Object)this.requestType));
        }
        this.request = httpRequestBase;
        httpRequestBase.setConfig((RequestConfig)cloneable);
        this.makeHeaders(httpRequestBase);
        this.response = CustomHttpRequest.execRequest(httpClientBuilder, httpRequestBase);
    }

    public void setHeadRequest() {
        this.requestType = CustomHttpRequest$Type.HEAD;
    }

    public MultiMap<String, String> getResponseHeaders() {
        this.checkResponse();
        MultiMap<String, String> multiMap = new MultiMap<String, String>();
        for (Header header : this.response.getAllHeaders()) {
            multiMap.putSingle(header.getName().toLowerCase(), header.getValue());
        }
        return multiMap;
    }

    public HttpEntity getResponseEntity() {
        this.checkResponse();
        return this.response.getEntity();
    }

    public String getResponseBody() {
        this.checkResponse();
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            return "";
        }
        try {
            return EntityUtils.toString(httpEntity);
        }
        catch (IOException iOException) {
            throw new CustomHttpException("Cannot read response body: " + iOException.getMessage());
        }
    }

    public int getResponseCode() {
        this.checkResponse();
        return this.response.getStatusLine().getStatusCode();
    }

    private void checkResponse() {
        if (this.response == null) {
            throw new CustomHttpException("Null HttpResponse object");
        }
    }

    private void makeHeaders(HttpRequest httpRequest) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpRequest.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public void abort() {
        if (this.request == null) {
            return;
        }
        if (this.request instanceof HttpGet) {
            ((HttpGet)this.request).abort();
        } else if (this.request instanceof HttpPost) {
            ((HttpPost)this.request).abort();
        } else if (this.request instanceof HttpHead) {
            ((HttpHead)this.request).abort();
        }
        if (this.response != null) {
            EntityUtils.consumeQuietly(this.response.getEntity());
        }
    }

    static {
        SSLContext sSLContext;
        try {
            sSLContext = SSLContextBuilder.create().setProtocol("TLSv1.2").build();
        }
        catch (Exception exception) {
            sSLContext = null;
        }
        TLS12 = sSLContext;
    }
}

