/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.logging;

import com.xiaomitool.v2.logging.Debugger$1;
import com.xiaomitool.v2.logging.Debugger$2;
import com.xiaomitool.v2.logging.Debugger$DatePath;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.FeedbackOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.output.NullOutputStream;

public class Debugger
extends BufferedOutputStream {
    private static final byte LOG_LINE_SEPARATOR = 10;
    private static final byte[] LINE_SEPARATOR = System.lineSeparator().getBytes(ResourcesConst.interalCharset());
    private static final String LOG_FN = "xmt2log_";
    private static final Pattern LOG_PATTERN = Pattern.compile("xmt2log_(\\d+)\\.txt$");
    private static final int MAX_LOG_FILES = 5;
    private static final int MAX_FEEDBACK_PAYLOAD_SIZE = 30000000;
    private static Debugger defaultDebugger;
    private final FeedbackOutputStream feedbackOutputStream = new FeedbackOutputStream();
    private DeflaterOutputStream gzipOutputStream;

    private Debugger(OutputStream outputStream) {
        super(outputStream);
    }

    public static Debugger fromOutputStream(OutputStream outputStream) {
        return new Debugger(outputStream);
    }

    public static Debugger defaultDebugger() {
        return Debugger.defaultDebugger(true);
    }

    public static Debugger defaultDebugger(boolean bl) {
        if (bl) {
            try {
                Debugger.deleteOldLogs();
            }
            catch (IOException iOException) {
                Log.error("Failed to identify old logs: " + iOException.getMessage());
            }
        }
        if (defaultDebugger == null) {
            try {
                Path path = ResourcesManager.getLogPath().resolve(LOG_FN + System.currentTimeMillis() + ".txt");
                Debugger.createDefaultPath(path);
                defaultDebugger = Debugger.fromOutputStream(new FileOutputStream(path.toFile()));
            }
            catch (Exception exception) {
                Log.error("Failed to create debug output stream: " + exception.getMessage());
                return Debugger.fromOutputStream(new NullOutputStream());
            }
        }
        return defaultDebugger;
    }

    private static void createDefaultPath(Path path) {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
    }

    private static void deleteOldLogs() {
        TreeSet<Debugger$DatePath> treeSet = Debugger.getExistingLogsFiles();
        new Thread(new Debugger$1(treeSet)).start();
    }

    private static TreeSet<Debugger$DatePath> getExistingLogsFiles() {
        Supplier<TreeSet> supplier = () -> new TreeSet<Debugger$DatePath>(Comparator.comparingLong(debugger$DatePath -> debugger$DatePath.date));
        try (Stream<Path> stream = Files.walk(ResourcesManager.getLogPath(), new FileVisitOption[0]);){
            TreeSet treeSet = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(new Debugger$2()).collect(Collectors.toCollection(supplier));
            return treeSet;
        }
    }

    private DeflaterOutputStream getCompressingOutputStream() {
        if (this.gzipOutputStream == null) {
            this.gzipOutputStream = new DeflaterOutputStream((OutputStream)this.feedbackOutputStream, new Deflater(9, false));
        }
        return this.gzipOutputStream;
    }

    public void setCompressingOutputStream(DeflaterOutputStream deflaterOutputStream) {
        this.gzipOutputStream = deflaterOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(Object object, boolean bl, boolean bl2) {
        byte[] byArray = String.valueOf(object).getBytes(ResourcesConst.interalCharset());
        if (!bl2) {
            this.write(byArray);
            this.write(LINE_SEPARATOR);
        }
        if (bl) {
            FeedbackOutputStream feedbackOutputStream = this.feedbackOutputStream;
            synchronized (feedbackOutputStream) {
                DeflaterOutputStream deflaterOutputStream = this.getCompressingOutputStream();
                ((OutputStream)deflaterOutputStream).write(byArray);
                ((OutputStream)deflaterOutputStream).write(10);
                ((OutputStream)deflaterOutputStream).flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFeedbackData(String string) {
        FeedbackOutputStream feedbackOutputStream = this.feedbackOutputStream;
        synchronized (feedbackOutputStream) {
            DeflaterOutputStream deflaterOutputStream = this.getCompressingOutputStream();
            deflaterOutputStream.finish();
            this.feedbackOutputStream.setFlagsOnClose(FeedbackOutputStream.FLAG_COMPRESSED);
            deflaterOutputStream.close();
            this.setCompressingOutputStream(new DeflaterOutputStream((OutputStream)this.feedbackOutputStream, new Deflater(9, false)));
            this.feedbackOutputStream.setUserMessage(string);
            return this.feedbackOutputStream.getReadInputStream();
        }
    }

    static /* synthetic */ Pattern access$000() {
        return LOG_PATTERN;
    }
}

