/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.logging;

import com.xiaomitool.v2.logging.Debugger;
import com.xiaomitool.v2.logging.LogUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.io.output.NullOutputStream;

public class Log {
    public static final boolean ADVANCED_LOG = false;
    private static final String PREFIX_DEBUG = "DEBUG";
    private static final String PREFIX_INFO = "INFO";
    private static final String PREFIX_WARN = "WARN";
    private static String PREFIX_ERROR = "ERROR";
    private static Debugger logOutput = Debugger.fromOutputStream(NullOutputStream.NULL_OUTPUT_STREAM);
    private static boolean LIVE_LOG = false;

    public static void init() {
        logOutput = Debugger.defaultDebugger();
        PrintStream printStream = new PrintStream(new NullOutputStream());
        System.setOut(printStream);
        System.setErr(printStream);
    }

    public static void log_private(Object object) {
        Log.log("PRIV", object, true, true);
    }

    public static void debug(Object object) {
    }

    public static void debugLine() {
    }

    public static void info(Object object) {
        Log.log(PREFIX_INFO, object, true);
    }

    public static void warn(Object object) {
        Log.log(PREFIX_WARN, object, true);
    }

    public static void error(Object object) {
        Log.log(PREFIX_ERROR, object, true);
    }

    public static void printStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.toString();
    }

    public static void process(Object object, boolean bl) {
        Log.log("PROC", object, bl);
    }

    public static void log(String string, Object object, boolean bl) {
        Log.log(string, object, bl, false);
    }

    private static void log(String string, Object object, boolean bl, boolean bl2) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = "";
        String string3 = String.format("%s[%-6s][%06x]%s %s", LogUtils.getTimeStamp(), string, Thread.currentThread().hashCode(), string2, object == null ? "null" : object.toString());
        if (LIVE_LOG) {
            System.out.println(string3);
        }
        if (logOutput != null) {
            try {
                logOutput.writeln(string3, bl, bl2);
            }
            catch (Exception exception) {
                System.out.println("Failed to write to feedback output: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public static void closeLogFile() {
        if (logOutput != null) {
            try {
                logOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String i(Number number) {
        String string = number.toString();
        if (number instanceof Long) {
            string = Long.toHexString((Long)number);
        } else if (number instanceof Integer) {
            string = Integer.toHexString((Integer)number);
        }
        return string;
    }

    public static Debugger getDebugger() {
        return logOutput;
    }

    public static void exc(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        Log.error(stringWriter.toString());
    }
}

