/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.logging.feedback;

import com.xiaomitool.v2.crypto.Hash;
import com.xiaomitool.v2.engine.ToolManager;
import com.xiaomitool.v2.gui.visual.CustomButton;
import com.xiaomitool.v2.inet.CustomHttpRequest;
import com.xiaomitool.v2.inet.EasyHttp;
import com.xiaomitool.v2.inet.EasyResponse;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Debugger;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.logging.feedback.LogSender$1;
import com.xiaomitool.v2.utility.FeedbackOutputStream;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import javafx.application.Platform;

public class LogSender {
    private static final String SALT_RESPONSE = "response_good";
    private static final String HOST_PATH = ToolManager.getFeedbackUrl();
    private static Instant lastSendSuccessInstant = null;
    private static int WAIT_BEFORE_SENDING = 300;
    private static boolean logSendCooldown;

    private static String getUploadToken() {
        return LogSender.getUploadToken(ToolManager.getRunningInstanceId());
    }

    private static String getUploadToken(String string) {
        if (StrUtils.isNullOrEmpty(string)) {
            return null;
        }
        String string2 = HOST_PATH + "/utok.php?iid=" + string;
        EasyResponse easyResponse = EasyHttp.get(string2);
        Log.log("LOG", "Feedback token request result: " + easyResponse.getCode() + " - " + easyResponse.getBody(), false);
        if (!easyResponse.isAllRight()) {
            return null;
        }
        String string3 = easyResponse.getBody();
        if (string3.length() < 96) {
            return null;
        }
        if (!Hash.md5Hex(string + SALT_RESPONSE).equalsIgnoreCase(string3.substring(0, 32))) {
            return null;
        }
        return string3.substring(32);
    }

    private static boolean sendFeedback(String string, String string2, Debugger debugger) {
        boolean bl;
        Object object;
        if (string == null || string.length() != 64) {
            Log.log("LOG", "Invalid token to send log: " + string, false);
            return false;
        }
        if (LogSender.getTimeFromLastSend() != -1) {
            Log.log("LOG", "Not enough time between log sending: " + LogSender.getTimeFromLastSend(), false);
            return false;
        }
        String string3 = ToolManager.getRunningInstanceId();
        string2 = string2 != null && !string2.trim().isEmpty() ? string2 + "\n" : null;
        Log.log("LOG", "Sending feedback with token: " + string, false);
        InputStream inputStream = null;
        if (debugger == null) {
            if (string2 != null && !string2.isEmpty()) {
                object = new FeedbackOutputStream();
                ((FeedbackOutputStream)object).setUserMessage(string2);
                inputStream = ((FeedbackOutputStream)object).getReadInputStream();
            }
        } else {
            inputStream = debugger.getFeedbackData(string2);
        }
        object = HOST_PATH + "/ufed.php?iid=" + string3 + "&t=" + string;
        CustomHttpRequest customHttpRequest = new CustomHttpRequest((String)object);
        customHttpRequest.setPostData(inputStream);
        customHttpRequest.execute();
        Log.log("LOG", "Feedback send result: " + customHttpRequest.getResponseCode() + " - " + customHttpRequest.getResponseBody(), false);
        boolean bl2 = bl = customHttpRequest.getResponseCode() == 200;
        if (bl) {
            lastSendSuccessInstant = Instant.now();
        }
        return bl;
    }

    static boolean sendSingleLog(byte[] byArray) {
        String string = LogSender.getUploadToken(SettingsUtils.requireHashedPCId());
        return LogSender.sendSingleLog(string, byArray);
    }

    private static boolean sendSingleLog(String string, byte[] byArray) {
        if (string == null || string.length() != 64) {
            Log.log("LOG", "Invalid token to send log: " + string, false);
            return false;
        }
        if (byArray == null || byArray.length < 4) {
            Log.log("LOG", "Invalid length data", false);
            return false;
        }
        String string2 = SettingsUtils.requireHashedPCId();
        String string3 = HOST_PATH + "/uliv.php?iid=" + string2 + "&t=" + string;
        CustomHttpRequest customHttpRequest = new CustomHttpRequest(string3);
        customHttpRequest.setPostData(byArray);
        customHttpRequest.execute();
        Log.log("LOG", "Feedback send result: " + customHttpRequest.getResponseCode() + " - " + customHttpRequest.getResponseBody(), false);
        return customHttpRequest.getResponseCode() == 200;
    }

    private static byte[] byteMerge(byte[] ... byArray) {
        int n = 0;
        for (byte[] byArray2 : byArray) {
            n += byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        n = 0;
        for (byte[] byArray4 : byArray) {
            System.arraycopy(byArray4, 0, byArray3, n, byArray4.length);
            n += byArray4.length;
        }
        return byArray3;
    }

    public static boolean uploadFeedback(String string, Debugger debugger) {
        String string2 = LogSender.getUploadToken();
        return LogSender.sendFeedback(string2, string, debugger);
    }

    public static boolean uploadFeedback(String string, boolean bl) {
        return LogSender.uploadFeedback(string, bl ? Log.getDebugger() : null);
    }

    public static boolean isLogCooldown() {
        return logSendCooldown;
    }

    public static Thread cooldownCounter(CustomButton customButton) {
        logSendCooldown = false;
        if (LogSender.getTimeFromLastSend() != -1) {
            logSendCooldown = true;
            Thread thread = new Thread(new LogSender$1(customButton));
            thread.start();
            return thread;
        }
        Platform.runLater(() -> {
            customButton.setText(LRes.SEND_FEEDBACK.toString());
            customButton.setDisable(false);
        });
        return null;
    }

    private static int getTimeFromLastSend() {
        try {
            if (lastSendSuccessInstant == null) {
                return -1;
            }
            Duration duration = Duration.between(lastSendSuccessInstant, Instant.now());
            long l = duration.getSeconds();
            return l < (long)WAIT_BEFORE_SENDING ? WAIT_BEFORE_SENDING - Math.toIntExact(l) : -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    static /* synthetic */ int access$000() {
        return LogSender.getTimeFromLastSend();
    }

    static /* synthetic */ boolean access$102(boolean bl) {
        logSendCooldown = bl;
        return logSendCooldown;
    }
}

