/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.fetch;

import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.inet.CustomHttpException;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.fetch.StockRecoveryFetch;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.rom.Installable;
import com.xiaomitool.v2.rom.Installable$Type;
import com.xiaomitool.v2.rom.MiuiRom$Kind;
import com.xiaomitool.v2.rom.MiuiRom$Specie;
import com.xiaomitool.v2.rom.MiuiZipRom;
import com.xiaomitool.v2.rom.chooser.InstallableChooser;
import com.xiaomitool.v2.xiaomi.a.b;
import com.xiaomitool.v2.xiaomi.c;
import com.xiaomitool.v2.xiaomi.miuithings.DeviceRequestParams;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion;
import java.util.HashMap;

final class StockRecoveryFetch$8
extends RInstall {
    final /* synthetic */ MiuiRom$Specie val$specie;
    final /* synthetic */ boolean val$enforceSameSpecie;

    StockRecoveryFetch$8(MiuiRom$Specie miuiRom$Specie, boolean bl) {
        this.val$specie = miuiRom$Specie;
        this.val$enforceSameSpecie = bl;
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        HashMap<MiuiRom$Kind, MiuiZipRom> hashMap;
        DeviceRequestParams deviceRequestParams;
        MiuiRom$Specie miuiRom$Specie = this.val$specie;
        Log.info("Looking for latest recovery rom of specie :" + (Object)((Object)this.val$specie));
        InstallableChooser installableChooser = Procedures.requireInstallableChooser(procedureRunner);
        Device device = Procedures.requireDevice(procedureRunner);
        try {
            deviceRequestParams = DeviceRequestParams.readFromDevice(device, true);
        }
        catch (AdbException adbException) {
            throw new InstallException(adbException);
        }
        if (miuiRom$Specie == null) {
            miuiRom$Specie = deviceRequestParams.getSpecie();
            if (miuiRom$Specie == null) {
                throw new InstallException("Failed to obtain device branch and region: null specie", InstallException$Code.MISSING_PROPERTY);
            }
        } else {
            deviceRequestParams.setSpecie(miuiRom$Specie);
        }
        String string = InstallableChooser.idBySpecie(miuiRom$Specie);
        Installable installable = installableChooser.getByType(string, Installable$Type.RECOVERY);
        MiuiVersion miuiVersion = null;
        if (installable != null) {
            if (installable.hasInstallToken()) {
                Procedures.setInstallable(procedureRunner, installable);
                return;
            }
            miuiVersion = installable.getMiuiVersion();
        }
        if (miuiVersion == null && (installable = installableChooser.getByType(string, Installable$Type.FASTBOOT)) != null) {
            miuiVersion = installable.getMiuiVersion();
        }
        if (miuiVersion == null) {
            Log.warn("No version available to request ota, using apis to get latest rom");
            StockRecoveryFetch.access$200(deviceRequestParams, miuiRom$Specie).run(procedureRunner);
            installable = Procedures.requireInstallable(procedureRunner);
            miuiVersion = installable.getMiuiVersion();
        }
        if (miuiVersion == null) {
            throw new InstallException("Failed to create romOta request: null version", InstallException$Code.INFO_RETRIVE_FAILED);
        }
        deviceRequestParams.setVersion(miuiVersion);
        String string2 = (String)procedureRunner.consumeContext("SFR_md5_key");
        if (string2 != null) {
            deviceRequestParams.setPkg(string2);
        }
        Log.info("Performing latest ota search request");
        procedureRunner.text(LRes.SEARCHING_LATEST_OTA_ROM.toString(deviceRequestParams.getSpecie().toHuman()));
        try {
            hashMap = b.a(deviceRequestParams);
        }
        catch (c c2) {
            throw new InstallException(c2);
        }
        catch (CustomHttpException customHttpException) {
            throw new InstallException(customHttpException);
        }
        Log.info("Found latest possible roms number: " + hashMap.size());
        MiuiZipRom miuiZipRom = StockRecoveryFetch.access$000(hashMap, this.val$specie);
        Log.info("Preferred latest rom chosen: " + installable);
        if (miuiZipRom == null) {
            throw new InstallException("Ota response doesn't contain an installable rom data", InstallException$Code.MISSING_PROPERTY);
        }
        if (this.val$enforceSameSpecie && !this.val$specie.equals((Object)miuiZipRom.getSpecie())) {
            throw new InstallException("Best rom found is not of the wanted specie", InstallException$Code.ROM_OTA_ERROR);
        }
        Procedures.setInstallable(procedureRunner, miuiZipRom);
    }
}

