/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.FastbootInstall$1$1;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.rom.Installable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;

final class FastbootInstall$1
extends RInstall {
    FastbootInstall$1() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        Installable installable = Procedures.requireInstallable(procedureRunner);
        File file = installable.getFinalFile();
        try {
            String string = SystemUtils.IS_OS_WINDOWS ? "flash_all.bat" : "flash_all.sh";
            Log.info("Searching file " + string + " in the extracted directory");
            Stream<Path> stream = Files.find(file.toPath(), 4, new FastbootInstall$1$1(this, string), new FileVisitOption[0]);
            List list = stream.collect(Collectors.toList());
            Log.info("Possible flash_all files found: " + list);
            if (list.size() == 0) {
                throw new InstallException("Flash all file not found in extracted dir: " + string, InstallException$Code.FILE_NOT_FOUND);
            }
            list.sort(Comparator.comparingInt(path -> path.toString().length()));
            Path path2 = (Path)list.get(0);
            Log.info("Choosen flash_all file: " + path2);
            procedureRunner.setContext("fast_flash_all_file", path2);
        }
        catch (IOException iOException) {
            throw new InstallException("IOException while finding flash_all file: " + iOException.getMessage(), InstallException$Code.FILE_NOT_FOUND, iOException);
        }
    }
}

