/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.utility.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class FastbootInstall$2
extends RInstall {
    FastbootInstall$2() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        String string;
        Path path = (Path)procedureRunner.requireContext("fast_flash_all_file");
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw new InstallException("Failed to obtain flash_all file", InstallException$Code.FILE_NOT_FOUND, "File " + path + " doesn't exists");
        }
        Log.info("Building custom flash_all file");
        File file = path.toFile();
        try {
            string = FileUtils.readAll(file);
        }
        catch (IOException iOException) {
            throw new InstallException("Failed to read flash_all file", InstallException$Code.IO_ERROR, iOException);
        }
        Log.info("Original flash_all file: ");
        Log.info(string);
        String[] stringArray = string.split("\\n");
        String string2 = ResourcesConst.isWindows() ? "flash_xiaomitool.bat" : "flash_xiaomitool.sh";
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        if (ResourcesConst.isWindows()) {
            stringBuilder.append("@echo off").append(System.lineSeparator());
            stringBuilder.append("echo Current dir: %~dp0").append(System.lineSeparator());
        }
        Pattern pattern = Pattern.compile("fastboot.+flash\\s+(\\w+)", 2);
        stringBuilder.append("echo Fastboot flash starting").append(System.lineSeparator());
        for (String string3 : stringArray) {
            if (string3.trim().toLowerCase().startsWith("pause")) continue;
            Matcher matcher = pattern.matcher(string3);
            if (matcher.find()) {
                stringBuilder.append("echo [Flashing ").append(matcher.group(1)).append("]").append(System.lineSeparator());
            }
            stringBuilder.append(string3).append(System.lineSeparator());
        }
        String string4 = stringBuilder.toString();
        File file2 = new File(file.getParentFile(), string2);
        Log.info("Custom flash_all file: " + file2);
        Log.info("Custom flash_all file content: ");
        Log.info(string4);
        try {
            FileUtils.writeAll(file2, string4);
        }
        catch (IOException iOException) {
            throw new InstallException("Failed to write to flash_xiaomitool file: " + iOException.getMessage(), InstallException$Code.IO_ERROR, iOException);
        }
        Log.info("Flash_all file generated success");
        procedureRunner.setContext("fast_flash_script_file", file2);
    }
}

