/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.procedure.install;

import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.Procedures;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.FastbootInstall$3$1;
import com.xiaomitool.v2.procedure.install.InstallException;
import com.xiaomitool.v2.procedure.install.InstallException$Code;
import com.xiaomitool.v2.process.ProcessRunner;
import com.xiaomitool.v2.process.ShellRunner;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.Pointer;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Pattern;

final class FastbootInstall$3
extends RInstall {
    FastbootInstall$3() {
    }

    @Override
    public void run(ProcedureRunner procedureRunner) {
        File file = (File)procedureRunner.requireContext("fast_flash_script_file");
        Path path = file.getParentFile().toPath();
        Log.info("Starting fastboot flash_all script: " + file);
        try {
            Log.info("Copying fastboot resources to flash_all file directory: " + path);
            ResourcesManager.copyResourcesToDir(ResourcesManager.getFastbootFilesPath(), path);
        }
        catch (Exception exception) {
            throw new InstallException("Failed to copy fastboot to flash_all dir: " + exception.getMessage(), InstallException$Code.FASTBOOT_FLASH_FAILED, exception);
        }
        Device device = Procedures.requireDevice(procedureRunner);
        if (file == null) {
            throw new InstallException("Null flash_all file", InstallException$Code.FILE_NOT_FOUND);
        }
        file.setExecutable(true);
        String string = file.toPath().getFileName().toString();
        if (!(ResourcesConst.isWindows() || string.startsWith("/") || string.startsWith("."))) {
            string = "./" + string;
        }
        Log.info("Flash_all argument passed to shell: " + string);
        ShellRunner shellRunner = new ShellRunner(new String[]{string});
        shellRunner.setWorkingDir(path.toFile());
        ((ProcessRunner)shellRunner).addArgument("-s");
        ((ProcessRunner)shellRunner).addArgument(device.getSerial());
        Pattern pattern = Pattern.compile("\\[(Flashing \\w+)\\]", 2);
        Pointer pointer = new Pointer();
        pointer.pointed = "";
        shellRunner.addSyncCallback(new FastbootInstall$3$1(this, pattern, procedureRunner, pointer));
        device.requireAccess();
        Log.info("Starting flash_all fastboot process");
        try {
            shellRunner.runWait(3000);
        }
        catch (IOException iOException) {
            device.releaseAccess();
            throw new InstallException("Failed to run flash_all file: " + iOException.getMessage(), InstallException$Code.IO_ERROR, iOException);
        }
        device.releaseAccess();
        int n = shellRunner.getExitValue();
        if (n != 0) {
            throw new InstallException("Fastboot flash all failed, exit code: " + n + ", output: " + pointer.pointed, InstallException$Code.FASTBOOT_FLASH_FAILED, StrUtils.lastLine(shellRunner.getOutputString()));
        }
        Log.info("Flash_all script run success");
    }
}

