/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom;

import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.FastbootInstall;
import com.xiaomitool.v2.rom.Installable$Type;
import com.xiaomitool.v2.rom.MiuiRom;
import com.xiaomitool.v2.rom.MiuiRom$Kind;
import com.xiaomitool.v2.rom.MiuiRom$Specie;
import com.xiaomitool.v2.rom.RomException;
import com.xiaomitool.v2.rom.interfaces.InstallObject;
import com.xiaomitool.v2.tasks.ExtractionTask;
import com.xiaomitool.v2.tasks.ExtractionTask$ExtractionType;
import com.xiaomitool.v2.tasks.TaskManager;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.xiaomi.miuithings.Codebase;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiuiTgzRom
extends MiuiRom {
    public MiuiTgzRom(String string, MiuiVersion miuiVersion, Codebase codebase, String string2, MiuiRom$Kind miuiRom$Kind, String string3, MiuiRom$Specie miuiRom$Specie) {
        super(Installable$Type.FASTBOOT, true, miuiVersion.toString() + "-" + string, true, true);
        this.filename = string;
        this.miuiVersion = miuiVersion;
        this.codebase = codebase;
        this.md5 = string2;
        this.kind = miuiRom$Kind;
        this.descriptionUrl = string3;
        this.specie = miuiRom$Specie;
    }

    public MiuiTgzRom(String string, MiuiRom$Specie miuiRom$Specie) {
        super(Installable$Type.FASTBOOT, true, string, true, true);
        this.downloadUrl = string;
        Pattern pattern = Pattern.compile("http\\w{0,1}://[^/]+/([^/]+)/([^/]+)$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new RomException("Not a valid download url: " + string);
        }
        this.miuiVersion = new MiuiVersion(matcher.group(1));
        this.branch = this.miuiVersion.getBranch();
        this.filename = matcher.group(2);
        this.specie = miuiRom$Specie;
        Pattern pattern2 = Pattern.compile("_([\\d.]{3,5})_(global|cn)");
        Matcher matcher2 = pattern2.matcher(this.filename);
        if (matcher2.find()) {
            this.codebase = new Codebase(matcher2.group(1));
        }
        this.unique = this.miuiVersion.toString() + "-" + this.filename;
    }

    public MiuiTgzRom(File file, boolean bl) {
        super(Installable$Type.FASTBOOT, true, file.getAbsolutePath(), false, true);
        this.type = Installable$Type.FASTBOOT;
        this.isOfficial = bl;
        this.downloadedFile = file;
        this.filename = file.getName();
    }

    public MiuiTgzRom(boolean bl) {
        super(Installable$Type.FASTBOOT, bl, "", false, true);
        this.setFake(true);
    }

    @Override
    protected Object extractInternal(UpdateListener updateListener) {
        ExtractionTask extractionTask = new ExtractionTask(updateListener, this.getDownloadedFile(), null, ExtractionTask$ExtractionType.TGZ, true);
        TaskManager taskManager = TaskManager.getInstance();
        taskManager.startSameThread(extractionTask);
        if (!extractionTask.isFinished()) {
            throw new RomException("Extract task failed");
        }
        File file = (File)extractionTask.getResult();
        this.setFinalFile(file);
        return file;
    }

    @Override
    public LinkedHashSet<Device$Status> getRequiredStates() {
        return InstallObject.SET_FASTBOOT;
    }

    @Override
    public RInstall getInstallProcedure() {
        return FastbootInstall.findBuildRunFlashAll();
    }
}

