/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.rom;

import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.procedure.install.StockRecoveryInstall;
import com.xiaomitool.v2.rom.Installable$Type;
import com.xiaomitool.v2.rom.MiuiRom;
import com.xiaomitool.v2.rom.MiuiRom$Kind;
import com.xiaomitool.v2.rom.MiuiRom$Specie;
import com.xiaomitool.v2.rom.RomException;
import com.xiaomitool.v2.rom.interfaces.InstallObject;
import com.xiaomitool.v2.utility.NotNull;
import com.xiaomitool.v2.xiaomi.miuithings.Branch;
import com.xiaomitool.v2.xiaomi.miuithings.Codebase;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiuiZipRom
extends MiuiRom {
    public MiuiZipRom(String string, @NotNull MiuiVersion miuiVersion, Branch branch, Codebase codebase, String string2, String string3, MiuiRom$Kind miuiRom$Kind, String string4, MiuiRom$Specie miuiRom$Specie) {
        super(Installable$Type.RECOVERY, true, miuiVersion.toString() + "-" + string, true, false);
        this.filename = string;
        this.miuiVersion = miuiVersion;
        this.codebase = codebase;
        this.installToken = string3;
        this.md5 = string2;
        this.kind = miuiRom$Kind;
        this.branch = branch;
        this.descriptionUrl = string4;
        this.downloadUrl = this.mirrors.resolve(miuiVersion.toString() + "/" + string);
        this.specie = miuiRom$Specie;
    }

    public MiuiZipRom(String string, MiuiRom$Specie miuiRom$Specie) {
        super(Installable$Type.RECOVERY, true, string, true, false);
        this.specie = miuiRom$Specie;
        this.downloadUrl = string;
        Pattern pattern = Pattern.compile("http\\w{0,1}://[^/]+/([^/]+)/([^/]+)$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new RomException("Not a valid download url: " + string);
        }
        this.miuiVersion = new MiuiVersion(matcher.group(1));
        this.branch = this.miuiVersion.getBranch();
        this.filename = matcher.group(2);
        Pattern pattern2 = Pattern.compile("_([\\d.]+)\\.zip");
        Matcher matcher2 = pattern2.matcher(this.filename);
        if (matcher2.find()) {
            this.codebase = new Codebase(matcher2.group(1));
        }
        this.unique = this.miuiVersion.toString() + "-" + this.filename;
    }

    public MiuiZipRom(File file, boolean bl) {
        super(Installable$Type.RECOVERY, bl, file.getAbsolutePath(), false, false);
        this.downloadedFile = file;
        this.finalFile = file;
        this.filename = file.getName();
    }

    public MiuiZipRom(boolean bl) {
        super(Installable$Type.RECOVERY, bl, "", false, false);
        this.setFake(true);
    }

    @Override
    public LinkedHashSet<Device$Status> getRequiredStates() {
        return this.isOfficial() ? InstallObject.SET_SIDELOAD : InstallObject.SET_RECOVERY;
    }

    @Override
    public RInstall getInstallProcedure() {
        return StockRecoveryInstall.stockRecoveryInstall();
    }
}

