/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.tasks;

import com.xiaomitool.v2.inet.CustomHttpException;
import com.xiaomitool.v2.inet.CustomHttpRequest;
import com.xiaomitool.v2.inet.EasyHttp;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.tasks.Task$STATUS;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;

public class DownloadTask
extends Task {
    private static final int DOWNLOAD_CHUNCK = 16384;
    private static final int WRITE_CHUNCK = 262144;
    private String url;
    private File destination;
    private Map<String, String> headers;
    private long totalSize = 0L;
    private long downloaded;

    public DownloadTask(UpdateListener updateListener, String string, String string2) {
        this(updateListener, string, string2 == null ? null : new File(string2));
    }

    public DownloadTask(UpdateListener updateListener, String string, File file) {
        super(updateListener);
        this.url = string;
        this.destination = file;
    }

    public void setHeaders(Map<String, String> map) {
        this.headers = map;
    }

    @Override
    protected void startInternal() {
        BufferedOutputStream bufferedOutputStream;
        InputStream inputStream;
        HttpEntity httpEntity;
        EasyHttp easyHttp = new EasyHttp().url(this.url);
        if (this.headers != null) {
            easyHttp.headers(this.headers);
        }
        CustomHttpRequest customHttpRequest = easyHttp.getHttpRequestObj();
        try {
            customHttpRequest.execute();
        }
        catch (CustomHttpException customHttpException) {
            this.error(customHttpException);
            return;
        }
        try {
            httpEntity = customHttpRequest.getResponseEntity();
        }
        catch (Exception exception) {
            this.error(exception);
            return;
        }
        int n = 200;
        try {
            n = customHttpRequest.getResponseCode();
        }
        catch (CustomHttpException customHttpException) {
            this.error(customHttpException);
        }
        if (n == 302) {
            String string;
            try {
                string = (String)((List)customHttpRequest.getResponseHeaders().get("location")).get(0);
            }
            catch (Exception exception) {
                this.error(exception);
                return;
            }
            this.url = string;
            this.startInternal();
            return;
        }
        if (n != 200) {
            this.error(new CustomHttpException("Response code is not valid: " + n));
            return;
        }
        if (this.destination == null) {
            this.destination = SettingsUtils.getDownloadFile(this.url);
        }
        this.totalSize = httpEntity.getContentLength();
        this.setTotalSize(this.totalSize);
        if (this.destination.exists() && this.destination.length() == this.totalSize && this.totalSize != 0L) {
            customHttpRequest.abort();
            this.finished(this.destination);
            return;
        }
        try {
            inputStream = httpEntity.getContent();
        }
        catch (IOException iOException) {
            this.error(iOException);
            return;
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.destination));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(fileNotFoundException);
            return;
        }
        byte[] byArray = new byte[16384];
        while (!Task$STATUS.ABORTED.equals((Object)this.status)) {
            if (Task$STATUS.PAUSED.equals((Object)this.status)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            try {
                int n2 = inputStream.read(byArray);
                if (n2 < 0) break;
                bufferedOutputStream.write(byArray, 0, n2);
                this.downloaded += (long)n2;
                this.update(this.downloaded);
            }
            catch (IOException iOException) {
                this.error(iOException);
                return;
            }
        }
        try {
            inputStream.close();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            this.error(iOException);
            return;
        }
        if (!Task$STATUS.ABORTED.equals((Object)this.status)) {
            this.finished(this.destination);
        }
    }

    @Override
    protected boolean canPause() {
        return true;
    }

    @Override
    protected boolean canStop() {
        return true;
    }

    @Override
    protected boolean pauseInternal() {
        return true;
    }

    @Override
    protected boolean stopInternal() {
        return true;
    }
}

