/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.tasks;

import com.xiaomitool.v2.crypto.Hash;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.tasks.ExtractionTask$1;
import com.xiaomitool.v2.tasks.ExtractionTask$2;
import com.xiaomitool.v2.tasks.ExtractionTask$ExtractionType;
import com.xiaomitool.v2.tasks.Task;
import com.xiaomitool.v2.tasks.Task$STATUS;
import com.xiaomitool.v2.tasks.UpdateListener;
import com.xiaomitool.v2.utility.FeedbackInputStream;
import com.xiaomitool.v2.utility.utils.FileUtils;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FilenameUtils;

public class ExtractionTask
extends Task {
    private static final int READ_BLOCK_SIZE = 16384;
    private static final int FILE_READ_BLOCK_SIZE = 131072;
    private File fileToExtract;
    private File dirExtractTo;
    private long fileSize = -1L;
    private long totalRead = 0L;
    private long lastTotal = 0L;
    private ExtractionTask$ExtractionType type;
    private boolean keepPath;

    public ExtractionTask(UpdateListener updateListener, File file, File file2, ExtractionTask$ExtractionType extractionTask$ExtractionType, boolean bl) {
        super(updateListener);
        this.fileToExtract = file;
        this.dirExtractTo = file2;
        this.type = extractionTask$ExtractionType;
        this.keepPath = bl;
    }

    public ExtractionTask(UpdateListener updateListener, String string, String string2, ExtractionTask$ExtractionType extractionTask$ExtractionType, boolean bl) {
        this(updateListener, new File(string), new File(string2), extractionTask$ExtractionType, bl);
    }

    @Override
    protected boolean canPause() {
        return true;
    }

    @Override
    protected boolean canStop() {
        return true;
    }

    @Override
    protected boolean pauseInternal() {
        return false;
    }

    @Override
    protected boolean stopInternal() {
        return false;
    }

    @Override
    public void startInternal() {
        Object object;
        Object object2;
        boolean bl;
        int n = 0;
        boolean bl2 = bl = this.dirExtractTo != null;
        do {
            if (!bl) {
                this.dirExtractTo = SettingsUtils.getExtractFile(this.fileToExtract, n);
            }
            bl = true;
            if (!this.dirExtractTo.exists()) continue;
            bl = false;
            ++n;
            object2 = this.getExtractionHash();
            object = new File(this.dirExtractTo, (String)object2);
            if (!((File)object).exists()) continue;
            this.finished(this.dirExtractTo);
            return;
        } while (!bl);
        try {
            Files.createDirectories(this.dirExtractTo.toPath(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            this.error(iOException);
            return;
        }
        this.fileSize = this.fileToExtract.length();
        this.setTotalSize(this.fileSize);
        object2 = null;
        try {
            switch (this.type) {
                case TAR: {
                    object2 = this.extractTar(this.keepPath);
                    break;
                }
                case TGZ: {
                    object2 = this.extractTgz(this.keepPath);
                    break;
                }
                case ZIP: {
                    object2 = this.extractZip(this.keepPath);
                    break;
                }
                case GZIP: {
                    object2 = this.extractGzip();
                    break;
                }
                case NONE: {
                    this.finished(this.fileToExtract);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            this.error(iOException);
            return;
        }
        object = this.getExtractionHash();
        File file = new File(this.dirExtractTo, (String)object);
        if (!file.exists()) {
            try {
                FileUtils.writeAll(file, this.toString());
            }
            catch (IOException iOException) {
                Log.warn("Failed to write file " + file + ": " + iOException.getMessage());
            }
        }
        this.finished(object2);
    }

    private File extractGzip() {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new FeedbackInputStream(new BufferedInputStream(new FileInputStream(this.fileToExtract), 131072), new ExtractionTask$1(this)));
        File file = new File(this.dirExtractTo, FilenameUtils.removeExtension(this.fileToExtract.getName()));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.ioRead(gZIPInputStream, fileOutputStream);
        ((InputStream)gZIPInputStream).close();
        ((OutputStream)fileOutputStream).close();
        return file;
    }

    private File extractZip(boolean bl) {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new FeedbackInputStream(new BufferedInputStream(new FileInputStream(this.fileToExtract), 131072), new ExtractionTask$2(this)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            File file = new File(this.dirExtractTo, bl ? string : FilenameUtils.getName(string));
            if (zipEntry.isDirectory()) {
                if (file.exists()) continue;
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
                continue;
            }
            if (!file.getParentFile().exists()) {
                Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.ioRead(zipInputStream, fileOutputStream);
            fileOutputStream.close();
        }
        zipInputStream.close();
        return this.dirExtractTo;
    }

    private File extractTar(boolean bl) {
        TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new FeedbackInputStream(new BufferedInputStream(new FileInputStream(this.fileToExtract), 131072), object -> this.onUpdateInternal((Integer)object)));
        return this.extractTarInternal(tarArchiveInputStream, bl);
    }

    private File extractTgz(boolean bl) {
        TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new GZIPInputStream(new FeedbackInputStream(new BufferedInputStream(new FileInputStream(this.fileToExtract), 131072), object -> this.onUpdateInternal((Integer)object))));
        return this.extractTarInternal(tarArchiveInputStream, bl);
    }

    private File extractTarInternal(TarArchiveInputStream tarArchiveInputStream, boolean bl) {
        ArchiveEntry archiveEntry;
        while ((archiveEntry = tarArchiveInputStream.getNextEntry()) != null) {
            File file = new File(this.dirExtractTo, bl ? archiveEntry.getName() : FilenameUtils.getName(archiveEntry.getName()));
            if (archiveEntry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.ioRead(tarArchiveInputStream, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        tarArchiveInputStream.close();
        return this.dirExtractTo;
    }

    private void ioRead(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[16384];
        int n = inputStream.read(byArray);
        while (n > 0 && !Task$STATUS.ABORTED.equals((Object)this.status)) {
            if (Task$STATUS.PAUSED.equals((Object)this.status)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    private void onUpdateInternal(int n) {
        this.totalRead += (long)n;
        if (this.totalRead - this.lastTotal > 0x100000L) {
            this.update(this.totalRead);
            this.lastTotal = this.totalRead;
        }
    }

    private String getExtractionHash() {
        String string = this.fileToExtract.toString() + this.type.toString() + this.fileToExtract.length();
        return "." + Hash.md5Hex(string);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.lineSeparator();
        try {
            stringBuilder.append("Extraction entry").append(string).append("Input file: ").append(this.fileToExtract.toString()).append(string).append("Output dir: ").append(this.dirExtractTo.toString()).append(string).append("Extraction type: ").append(this.type.toString()).append(string).append("File size: ").append(this.fileToExtract.length());
        }
        catch (Throwable throwable) {
            return "Extraction entry" + string + "Failed to get all info: " + throwable.getMessage();
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ void access$000(ExtractionTask extractionTask, int n) {
        extractionTask.onUpdateInternal(n);
    }
}

