/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.engine.ToolManager;
import com.xiaomitool.v2.inet.CustomHttpException;
import com.xiaomitool.v2.inet.EasyHttp;
import com.xiaomitool.v2.inet.EasyResponse;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.utility.WaitSemaphore;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class InetUtils {
    static boolean internetAvailable;
    static int tried;

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String getRedirectUrl(String string) {
        return InetUtils.getRedirectUrl(string, null);
    }

    public static String getRedirectUrl(String string, String string2) {
        EasyResponse easyResponse;
        List list;
        EasyHttp easyHttp = new EasyHttp().url(string).setHeadOnly();
        if (string2 != null) {
            easyHttp = easyHttp.referer(string2);
        }
        if ((list = (List)(easyResponse = easyHttp.exec()).getHeaders().get("location")) == null) {
            return null;
        }
        return (String)list.get(0);
    }

    public static void openUrlInBrowser(String string) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI(string));
                    return;
                }
                catch (Exception exception) {
                    Log.error("Failed to open url " + string + " using java.awt.Desktop: " + exception.getMessage());
                }
            }
            String string2 = "";
            string2 = SystemUtils.IS_OS_WINDOWS ? "rundll32 url.dll,FileProtocolHandler " + string : (SystemUtils.IS_OS_MAC ? "open " + string : "xdg-open " + string);
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec(string2);
            }
            catch (IOException iOException) {
                Log.error("Failed to open url " + string + " using runtime command: " + iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Log.error("Failed to open url " + string + " : " + throwable.getMessage());
        }
    }

    private static boolean isReachable(String string) {
        return InetUtils.isReachable(string, 80, 5000);
    }

    private static boolean isReachable(String string, int n, int n2) {
        try {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(string, n), n2);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static synchronized boolean isInternetAvailable() {
        internetAvailable = false;
        tried = 0;
        WaitSemaphore waitSemaphore = new WaitSemaphore(0);
        new Thread(() -> {
            try {
                ++tried;
                InetAddress inetAddress = InetAddress.getByName("www.xiaomitool.com");
                if (inetAddress.isReachable(5000)) {
                    Log.info("xiaomitool.com is reachable");
                    internetAvailable = true;
                    waitSemaphore.increase();
                    return;
                }
                Log.warn("xiaomitool.com is not reachable");
            }
            catch (IOException iOException) {
                Log.error("Failed to reach xmt host: " + iOException.getMessage());
            }
            if (InetUtils.isReachable("www.xiaomitool.com")) {
                Log.info("but it is reachable on port 80");
                internetAvailable = true;
                waitSemaphore.increase();
                return;
            }
            if (tried >= 3) {
                Log.error("Tried to reach three host and no one was reachable");
                waitSemaphore.increase();
            }
        }).start();
        new Thread(() -> {
            try {
                ++tried;
                InetAddress inetAddress = InetAddress.getByName("www.google.com");
                if (inetAddress.isReachable(5000)) {
                    Log.info("google.com is reachable");
                    internetAvailable = true;
                    waitSemaphore.increase();
                    return;
                }
                Log.warn("google.com is not reachable");
            }
            catch (IOException iOException) {
                Log.error("Failed to reach google host: " + iOException.getMessage());
            }
            if (InetUtils.isReachable("www.google.com")) {
                Log.info("but it is reachable on port 80");
                internetAvailable = true;
                waitSemaphore.increase();
                return;
            }
            if (tried >= 3) {
                Log.error("Tried to reach three host and no one was reachable");
                waitSemaphore.increase();
            }
        }).start();
        new Thread(() -> {
            try {
                ++tried;
                InetAddress inetAddress = InetAddress.getByName("www.miui.com");
                if (inetAddress.isReachable(5000)) {
                    Log.info("miui.com is reachable");
                    internetAvailable = true;
                    waitSemaphore.increase();
                    return;
                }
                Log.warn("miui.com is not reachable");
            }
            catch (IOException iOException) {
                Log.error("Failed to reach miui host: " + iOException.getMessage());
            }
            if (InetUtils.isReachable("www.miui.com")) {
                Log.info("but it is reachable on port 80");
                internetAvailable = true;
                waitSemaphore.increase();
                return;
            }
            if (tried >= 3) {
                Log.error("Tried to reach three host and no one was reachable");
                waitSemaphore.increase();
            }
        }).start();
        try {
            waitSemaphore.waitOnce();
        }
        catch (InterruptedException interruptedException) {
            Log.error("Internet check failed because thread interrupted: " + interruptedException.getMessage());
        }
        return internetAvailable;
    }

    public static int checkForUpdates(String string, String string2, String string3) {
        EasyResponse easyResponse = null;
        try {
            easyResponse = EasyHttp.get(string + "?v=" + string2 + "&i=" + string3);
        }
        catch (CustomHttpException customHttpException) {
            Log.error("Failed to run update request: " + customHttpException.getMessage());
            return -6;
        }
        if (!easyResponse.isCodeRight()) {
            Log.error("Update request returned with code: " + easyResponse.getCode());
            return -2;
        }
        if (!easyResponse.isAllRight()) {
            Log.error("Update request has empty body");
            return -3;
        }
        String string4 = easyResponse.getBody();
        if (string4 == null) {
            Log.error("Update response object has null body");
            return -4;
        }
        if ("ALLRIGHT".equals(string4 = string4.trim())) {
            return 0;
        }
        if ("UPDATE".equals(string4)) {
            return 1;
        }
        if ("INVALID".equals(string4)) {
            Log.error("Update request is not valid: v=" + string2 + ", i=" + string3);
            return -1;
        }
        if ("BLOCK".equals(string4)) {
            ToolManager.exit(-1);
            return -100;
        }
        Log.error("Unknown response from update request: " + string4);
        return -5;
    }

    static {
        tried = 0;
    }
}

