/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.utility.utils;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.resources.ResourcesManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class MutexUtils {
    private static final int SOCKET_PORT = 53435;
    private static final String MUTEX_FILENAME = ".instance.lock";
    private static final Path MUTEX_PATH = ResourcesManager.getSystemTmpPath().resolve(".instance.lock");
    private static boolean fileLocked = false;
    private static boolean socketLocked = false;
    private static FileLock lock;
    private static ServerSocket serverSocket;

    public static boolean lock() {
        boolean bl = MutexUtils.lockFile();
        boolean bl2 = MutexUtils.lockSocket();
        return bl || bl2;
    }

    private static boolean lockSocket() {
        if (socketLocked) {
            return false;
        }
        boolean bl = true;
        try {
            serverSocket = new ServerSocket(53435);
            socketLocked = true;
        }
        catch (Throwable throwable) {
            Log.error("Failed to create mutex socket");
            serverSocket = null;
            bl = false;
        }
        return bl;
    }

    private static boolean lockFile() {
        try {
            FileChannel fileChannel;
            if (fileLocked) {
                return false;
            }
            if (!Files.exists(MUTEX_PATH, new LinkOption[0])) {
                try {
                    Files.createFile(MUTEX_PATH, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    Log.error("Failed to create mutex file: " + iOException.getMessage());
                    return true;
                }
                try {
                    Files.setAttribute(MUTEX_PATH, "dos:hidden", true, new LinkOption[0]);
                }
                catch (IOException iOException) {
                    Log.warn("Failed to hide mutex file: " + iOException.getMessage());
                }
            }
            try {
                fileChannel = FileChannel.open(MUTEX_PATH, StandardOpenOption.WRITE);
            }
            catch (IOException iOException) {
                Log.error("Failed to open mutex file: " + iOException.getMessage());
                return false;
            }
            try {
                lock = fileChannel.tryLock();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (lock == null) {
                Log.warn("Mutex not available");
                return false;
            }
            fileLocked = true;
            return true;
        }
        catch (Throwable throwable) {
            Log.error("Failed to lock mutex: unmanaged exception: " + throwable.getMessage());
            return false;
        }
    }

    private static boolean unlockFile() {
        if (!fileLocked || lock == null) {
            return false;
        }
        try {
            lock.release();
        }
        catch (IOException iOException) {
            Log.error("Failed to release mutex file lock");
            return false;
        }
        fileLocked = false;
        lock = null;
        return true;
    }

    private static boolean unlockSocket() {
        if (!socketLocked || serverSocket == null) {
            return false;
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean unlock() {
        boolean bl = MutexUtils.unlockFile();
        boolean bl2 = MutexUtils.unlockSocket();
        return bl || bl2;
    }

    public static boolean waitUnlock(int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (MutexUtils.lock()) {
                bl = true;
                break;
            }
            Thread.sleep(1000L);
        }
        return bl || MutexUtils.unlock();
    }
}

