/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.xiaomi.miuithings;

import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.adb.device.DeviceProperties;
import com.xiaomitool.v2.rom.MiuiRom$Specie;
import com.xiaomitool.v2.utility.Nullable;
import com.xiaomitool.v2.utility.utils.ObjUtils;
import com.xiaomitool.v2.xiaomi.miuithings.Branch;
import com.xiaomitool.v2.xiaomi.miuithings.DefaultRequestParams;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion;
import com.xiaomitool.v2.xiaomi.miuithings.SerialNumber;

public class DeviceRequestParams
extends DefaultRequestParams
implements Cloneable {
    public DeviceRequestParams(String string, String string2, String string3, @Nullable Branch branch, SerialNumber serialNumber, int n) {
        super(string, string2, string3, branch);
        this.serialNumber = serialNumber;
        this.zone = n;
    }

    public static DeviceRequestParams readFromDevice(Device device) {
        return DeviceRequestParams.readFromDevice(device, false);
    }

    public static DeviceRequestParams readFromDevice(Device device, boolean bl) {
        int n;
        DeviceProperties deviceProperties = device.getDeviceProperties();
        String string = deviceProperties.getCodename(false);
        if (string == null) {
            throw new AdbException("Missing device codename in device properties");
        }
        String string2 = (String)deviceProperties.get("ro.build.version.incremental");
        String string3 = (String)deviceProperties.get("ro.build.version.release");
        if (string3 != null) {
            if (string3.length() == 1) {
                string3 = string3 + ".0";
            } else if (string3.endsWith(".")) {
                string3 = string3 + "0";
            }
        }
        String string4 = (String)deviceProperties.get("ro.rom.zone");
        SerialNumber serialNumber = device.getAnswers().getSerialNumber();
        if (bl) {
            try {
                ObjUtils.checkNotNull(string2, "version");
                ObjUtils.checkNotNull(string3, "codebase");
                ObjUtils.checkNotNull(serialNumber, "serialNumber");
                if (!serialNumber.isValid()) {
                    throw new NullPointerException("serial number is invalid: " + serialNumber);
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new AdbException("Missing required ota parameter in device properties: " + nullPointerException.getMessage());
            }
        }
        if (string4 == null || string4.isEmpty()) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(string4.trim());
            }
            catch (Throwable throwable) {
                n = MiuiRom$Specie.getZone(string);
            }
        }
        MiuiVersion miuiVersion = new MiuiVersion(string2);
        Branch branch = (Branch)((Object)deviceProperties.get("xmt.branch"));
        if (branch == null) {
            branch = miuiVersion.getBranch();
        }
        return new DeviceRequestParams(string, string2, string3, branch, serialNumber, n);
    }

    @Override
    public DeviceRequestParams clone() {
        return (DeviceRequestParams)super.clone();
    }
}

