/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.xiaomi.miuithings;

import com.xiaomitool.v2.utility.utils.ArrayUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.util.Base64;
import java.util.regex.Pattern;

public class SerialNumber {
    public static final SerialNumber SN_ZERO = new SerialNumber("00000000", true);
    private static final Pattern INVALID_HEX_RAPR = Pattern.compile("[^0-9a-f]", 2);
    private String hexRapresentation = null;
    private boolean hasZeroX;

    private SerialNumber(String string, boolean bl) {
        this.hexRapresentation = string;
        this.hasZeroX = bl;
    }

    public static SerialNumber fromHexString(String string) {
        if (StrUtils.isNullOrEmpty(string)) {
            return null;
        }
        boolean bl = false;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2);
            bl = true;
        }
        return new SerialNumber(string, bl);
    }

    public static SerialNumber fromFastbootToken(String string) {
        if (StrUtils.isNullOrEmpty(string)) {
            return null;
        }
        try {
            byte by;
            byte[] byArray = Base64.getDecoder().decode(string);
            if (byArray.length < 4) {
                return null;
            }
            String string2 = null;
            if (byArray[0] == 85 && ((by = byArray[3]) + 4 == byArray.length || by + 2 == byArray.length)) {
                int n;
                for (int i = 4; i < byArray.length && i < by + 4; i += n + 2) {
                    byte by2 = byArray[i];
                    n = byArray[i + 1];
                    n = Integer.min(n, byArray.length - i - 2);
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, i + 2, byArray2, 0, n);
                    if (by2 != 2) continue;
                    string2 = StrUtils.toHexString(byArray2);
                }
            }
            if (string2 == null) {
                String string3 = StrUtils.toHexString(ArrayUtils.reverse(byArray));
                if (string3.length() < 8) {
                    return null;
                }
                string2 = string3.substring(0, 8);
            }
            return new SerialNumber(string2, true);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String toHexString() {
        if (StrUtils.isNullOrEmpty(this.hexRapresentation)) {
            return "0x00000000";
        }
        return "0x" + this.hexRapresentation;
    }

    public boolean isZero() {
        if (StrUtils.isNullOrEmpty(this.hexRapresentation)) {
            return true;
        }
        for (char c2 : this.hexRapresentation.toCharArray()) {
            if (c2 == '0') continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (this.isZero()) {
            return false;
        }
        return !INVALID_HEX_RAPR.matcher(this.hexRapresentation).find();
    }

    public String toString() {
        if (this.isValid()) {
            return this.toHexString();
        }
        return "0xINVALIDSN";
    }
}

