/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.language.DoubleMetaphone$DoubleMetaphoneResult;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    private int maxCodeLen = 4;

    public String doubleMetaphone(String string) {
        return this.doubleMetaphone(string, false);
    }

    public String doubleMetaphone(String string, boolean bl) {
        if ((string = this.cleanInput(string)) == null) {
            return null;
        }
        boolean bl2 = this.isSlavoGermanic(string);
        int n = this.isSilentStart(string) ? 1 : 0;
        DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult = new DoubleMetaphone$DoubleMetaphoneResult(this, this.getMaxCodeLen());
        block25: while (!doubleMetaphone$DoubleMetaphoneResult.isComplete() && n <= string.length() - 1) {
            switch (string.charAt(n)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    n = this.handleAEIOUY(doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'B': {
                    doubleMetaphone$DoubleMetaphoneResult.append('P');
                    n = this.charAt(string, n + 1) == 'B' ? n + 2 : n + 1;
                    continue block25;
                }
                case '\u00c7': {
                    doubleMetaphone$DoubleMetaphoneResult.append('S');
                    ++n;
                    continue block25;
                }
                case 'C': {
                    n = this.handleC(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'D': {
                    n = this.handleD(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'F': {
                    doubleMetaphone$DoubleMetaphoneResult.append('F');
                    n = this.charAt(string, n + 1) == 'F' ? n + 2 : n + 1;
                    continue block25;
                }
                case 'G': {
                    n = this.handleG(string, doubleMetaphone$DoubleMetaphoneResult, n, bl2);
                    continue block25;
                }
                case 'H': {
                    n = this.handleH(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'J': {
                    n = this.handleJ(string, doubleMetaphone$DoubleMetaphoneResult, n, bl2);
                    continue block25;
                }
                case 'K': {
                    doubleMetaphone$DoubleMetaphoneResult.append('K');
                    n = this.charAt(string, n + 1) == 'K' ? n + 2 : n + 1;
                    continue block25;
                }
                case 'L': {
                    n = this.handleL(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'M': {
                    doubleMetaphone$DoubleMetaphoneResult.append('M');
                    n = this.conditionM0(string, n) ? n + 2 : n + 1;
                    continue block25;
                }
                case 'N': {
                    doubleMetaphone$DoubleMetaphoneResult.append('N');
                    n = this.charAt(string, n + 1) == 'N' ? n + 2 : n + 1;
                    continue block25;
                }
                case '\u00d1': {
                    doubleMetaphone$DoubleMetaphoneResult.append('N');
                    ++n;
                    continue block25;
                }
                case 'P': {
                    n = this.handleP(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'Q': {
                    doubleMetaphone$DoubleMetaphoneResult.append('K');
                    n = this.charAt(string, n + 1) == 'Q' ? n + 2 : n + 1;
                    continue block25;
                }
                case 'R': {
                    n = this.handleR(string, doubleMetaphone$DoubleMetaphoneResult, n, bl2);
                    continue block25;
                }
                case 'S': {
                    n = this.handleS(string, doubleMetaphone$DoubleMetaphoneResult, n, bl2);
                    continue block25;
                }
                case 'T': {
                    n = this.handleT(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'V': {
                    doubleMetaphone$DoubleMetaphoneResult.append('F');
                    n = this.charAt(string, n + 1) == 'V' ? n + 2 : n + 1;
                    continue block25;
                }
                case 'W': {
                    n = this.handleW(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'X': {
                    n = this.handleX(string, doubleMetaphone$DoubleMetaphoneResult, n);
                    continue block25;
                }
                case 'Z': {
                    n = this.handleZ(string, doubleMetaphone$DoubleMetaphoneResult, n, bl2);
                    continue block25;
                }
            }
            ++n;
        }
        return bl ? doubleMetaphone$DoubleMetaphoneResult.getAlternate() : doubleMetaphone$DoubleMetaphoneResult.getPrimary();
    }

    @Override
    public Object encode(Object object) {
        if (!(object instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)object);
    }

    @Override
    public String encode(String string) {
        return this.doubleMetaphone(string);
    }

    public boolean isDoubleMetaphoneEqual(String string, String string2) {
        return this.isDoubleMetaphoneEqual(string, string2, false);
    }

    public boolean isDoubleMetaphoneEqual(String string, String string2, boolean bl) {
        return StringUtils.equals(this.doubleMetaphone(string, bl), this.doubleMetaphone(string2, bl));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int n) {
        this.maxCodeLen = n;
    }

    private int handleAEIOUY(DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (n == 0) {
            doubleMetaphone$DoubleMetaphoneResult.append('A');
        }
        return n + 1;
    }

    private int handleC(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (this.conditionC0(string, n)) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            n += 2;
        } else if (n == 0 && DoubleMetaphone.contains(string, n, 6, "CAESAR")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S');
            n += 2;
        } else if (DoubleMetaphone.contains(string, n, 2, "CH")) {
            n = this.handleCH(string, doubleMetaphone$DoubleMetaphoneResult, n);
        } else if (DoubleMetaphone.contains(string, n, 2, "CZ") && !DoubleMetaphone.contains(string, n - 2, 4, "WICZ")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
            n += 2;
        } else if (DoubleMetaphone.contains(string, n + 1, 3, "CIA")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
            n += 3;
        } else {
            if (DoubleMetaphone.contains(string, n, 2, "CC") && (n != 1 || this.charAt(string, 0) != 'M')) {
                return this.handleCC(string, doubleMetaphone$DoubleMetaphoneResult, n);
            }
            if (DoubleMetaphone.contains(string, n, 2, "CK", "CG", "CQ")) {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
                n += 2;
            } else if (DoubleMetaphone.contains(string, n, 2, "CI", "CE", "CY")) {
                if (DoubleMetaphone.contains(string, n, 3, "CIO", "CIE", "CIA")) {
                    doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
                } else {
                    doubleMetaphone$DoubleMetaphoneResult.append('S');
                }
                n += 2;
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
                n = DoubleMetaphone.contains(string, n + 1, 2, " C", " Q", " G") ? (n += 3) : (DoubleMetaphone.contains(string, n + 1, 1, "C", "K", "Q") && !DoubleMetaphone.contains(string, n + 1, 2, "CE", "CI") ? (n += 2) : ++n);
            }
        }
        return n;
    }

    private int handleCC(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (DoubleMetaphone.contains(string, n + 2, 1, "I", "E", "H") && !DoubleMetaphone.contains(string, n + 2, 2, "HU")) {
            if (n == 1 && this.charAt(string, n - 1) == 'A' || DoubleMetaphone.contains(string, n - 1, 5, "UCCEE", "UCCES")) {
                doubleMetaphone$DoubleMetaphoneResult.append("KS");
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X');
            }
            n += 3;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            n += 2;
        }
        return n;
    }

    private int handleCH(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (n > 0 && DoubleMetaphone.contains(string, n, 4, "CHAE")) {
            doubleMetaphone$DoubleMetaphoneResult.append('K', 'X');
            return n + 2;
        }
        if (this.conditionCH0(string, n)) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            return n + 2;
        }
        if (this.conditionCH1(string, n)) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            return n + 2;
        }
        if (n > 0) {
            if (DoubleMetaphone.contains(string, 0, 2, "MC")) {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X', 'K');
            }
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
        }
        return n + 2;
    }

    private int handleD(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (DoubleMetaphone.contains(string, n, 2, "DG")) {
            if (DoubleMetaphone.contains(string, n + 2, 1, "I", "E", "Y")) {
                doubleMetaphone$DoubleMetaphoneResult.append('J');
                n += 3;
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append("TK");
                n += 2;
            }
        } else if (DoubleMetaphone.contains(string, n, 2, "DT", "DD")) {
            doubleMetaphone$DoubleMetaphoneResult.append('T');
            n += 2;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('T');
            ++n;
        }
        return n;
    }

    private int handleG(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n, boolean bl) {
        if (this.charAt(string, n + 1) == 'H') {
            n = this.handleGH(string, doubleMetaphone$DoubleMetaphoneResult, n);
        } else if (this.charAt(string, n + 1) == 'N') {
            if (n == 1 && this.isVowel(this.charAt(string, 0)) && !bl) {
                doubleMetaphone$DoubleMetaphoneResult.append("KN", "N");
            } else if (!DoubleMetaphone.contains(string, n + 2, 2, "EY") && this.charAt(string, n + 1) != 'Y' && !bl) {
                doubleMetaphone$DoubleMetaphoneResult.append("N", "KN");
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append("KN");
            }
            n += 2;
        } else if (DoubleMetaphone.contains(string, n + 1, 2, "LI") && !bl) {
            doubleMetaphone$DoubleMetaphoneResult.append("KL", "L");
            n += 2;
        } else if (n == 0 && (this.charAt(string, n + 1) == 'Y' || DoubleMetaphone.contains(string, n + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            doubleMetaphone$DoubleMetaphoneResult.append('K', 'J');
            n += 2;
        } else if (!(!DoubleMetaphone.contains(string, n + 1, 2, "ER") && this.charAt(string, n + 1) != 'Y' || DoubleMetaphone.contains(string, 0, 6, "DANGER", "RANGER", "MANGER") || DoubleMetaphone.contains(string, n - 1, 1, "E", "I") || DoubleMetaphone.contains(string, n - 1, 3, "RGY", "OGY"))) {
            doubleMetaphone$DoubleMetaphoneResult.append('K', 'J');
            n += 2;
        } else if (DoubleMetaphone.contains(string, n + 1, 1, "E", "I", "Y") || DoubleMetaphone.contains(string, n - 1, 4, "AGGI", "OGGI")) {
            if (DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH") || DoubleMetaphone.contains(string, n + 1, 2, "ET")) {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
            } else if (DoubleMetaphone.contains(string, n + 1, 3, "IER")) {
                doubleMetaphone$DoubleMetaphoneResult.append('J');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('J', 'K');
            }
            n += 2;
        } else if (this.charAt(string, n + 1) == 'G') {
            n += 2;
            doubleMetaphone$DoubleMetaphoneResult.append('K');
        } else {
            ++n;
            doubleMetaphone$DoubleMetaphoneResult.append('K');
        }
        return n;
    }

    private int handleGH(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (n > 0 && !this.isVowel(this.charAt(string, n - 1))) {
            doubleMetaphone$DoubleMetaphoneResult.append('K');
            n += 2;
        } else if (n == 0) {
            if (this.charAt(string, n + 2) == 'I') {
                doubleMetaphone$DoubleMetaphoneResult.append('J');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
            }
            n += 2;
        } else if (n > 1 && DoubleMetaphone.contains(string, n - 2, 1, "B", "H", "D") || n > 2 && DoubleMetaphone.contains(string, n - 3, 1, "B", "H", "D") || n > 3 && DoubleMetaphone.contains(string, n - 4, 1, "B", "H")) {
            n += 2;
        } else {
            if (n > 2 && this.charAt(string, n - 1) == 'U' && DoubleMetaphone.contains(string, n - 3, 1, "C", "G", "L", "R", "T")) {
                doubleMetaphone$DoubleMetaphoneResult.append('F');
            } else if (n > 0 && this.charAt(string, n - 1) != 'I') {
                doubleMetaphone$DoubleMetaphoneResult.append('K');
            }
            n += 2;
        }
        return n;
    }

    private int handleH(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if ((n == 0 || this.isVowel(this.charAt(string, n - 1))) && this.isVowel(this.charAt(string, n + 1))) {
            doubleMetaphone$DoubleMetaphoneResult.append('H');
            n += 2;
        } else {
            ++n;
        }
        return n;
    }

    private int handleJ(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n, boolean bl) {
        if (DoubleMetaphone.contains(string, n, 4, "JOSE") || DoubleMetaphone.contains(string, 0, 4, "SAN ")) {
            if (n == 0 && this.charAt(string, n + 4) == ' ' || string.length() == 4 || DoubleMetaphone.contains(string, 0, 4, "SAN ")) {
                doubleMetaphone$DoubleMetaphoneResult.append('H');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('J', 'H');
            }
            ++n;
        } else {
            if (n == 0 && !DoubleMetaphone.contains(string, n, 4, "JOSE")) {
                doubleMetaphone$DoubleMetaphoneResult.append('J', 'A');
            } else if (this.isVowel(this.charAt(string, n - 1)) && !bl && (this.charAt(string, n + 1) == 'A' || this.charAt(string, n + 1) == 'O')) {
                doubleMetaphone$DoubleMetaphoneResult.append('J', 'H');
            } else if (n == string.length() - 1) {
                doubleMetaphone$DoubleMetaphoneResult.append('J', ' ');
            } else if (!DoubleMetaphone.contains(string, n + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(string, n - 1, 1, "S", "K", "L")) {
                doubleMetaphone$DoubleMetaphoneResult.append('J');
            }
            n = this.charAt(string, n + 1) == 'J' ? (n += 2) : ++n;
        }
        return n;
    }

    private int handleL(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (this.charAt(string, n + 1) == 'L') {
            if (this.conditionL0(string, n)) {
                doubleMetaphone$DoubleMetaphoneResult.appendPrimary('L');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('L');
            }
            n += 2;
        } else {
            ++n;
            doubleMetaphone$DoubleMetaphoneResult.append('L');
        }
        return n;
    }

    private int handleP(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (this.charAt(string, n + 1) == 'H') {
            doubleMetaphone$DoubleMetaphoneResult.append('F');
            n += 2;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('P');
            n = DoubleMetaphone.contains(string, n + 1, 1, "P", "B") ? n + 2 : n + 1;
        }
        return n;
    }

    private int handleR(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n, boolean bl) {
        if (n == string.length() - 1 && !bl && DoubleMetaphone.contains(string, n - 2, 2, "IE") && !DoubleMetaphone.contains(string, n - 4, 2, "ME", "MA")) {
            doubleMetaphone$DoubleMetaphoneResult.appendAlternate('R');
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('R');
        }
        return this.charAt(string, n + 1) == 'R' ? n + 2 : n + 1;
    }

    private int handleS(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n, boolean bl) {
        if (DoubleMetaphone.contains(string, n - 1, 3, "ISL", "YSL")) {
            ++n;
        } else if (n == 0 && DoubleMetaphone.contains(string, n, 5, "SUGAR")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X', 'S');
            ++n;
        } else if (DoubleMetaphone.contains(string, n, 2, "SH")) {
            if (DoubleMetaphone.contains(string, n + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ")) {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X');
            }
            n += 2;
        } else if (DoubleMetaphone.contains(string, n, 3, "SIO", "SIA") || DoubleMetaphone.contains(string, n, 4, "SIAN")) {
            if (bl) {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
            }
            n += 3;
        } else if (n == 0 && DoubleMetaphone.contains(string, n + 1, 1, "M", "N", "L", "W") || DoubleMetaphone.contains(string, n + 1, 1, "Z")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S', 'X');
            n = DoubleMetaphone.contains(string, n + 1, 1, "Z") ? n + 2 : n + 1;
        } else if (DoubleMetaphone.contains(string, n, 2, "SC")) {
            n = this.handleSC(string, doubleMetaphone$DoubleMetaphoneResult, n);
        } else {
            if (n == string.length() - 1 && DoubleMetaphone.contains(string, n - 2, 2, "AI", "OI")) {
                doubleMetaphone$DoubleMetaphoneResult.appendAlternate('S');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            }
            n = DoubleMetaphone.contains(string, n + 1, 1, "S", "Z") ? n + 2 : n + 1;
        }
        return n;
    }

    private int handleSC(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (this.charAt(string, n + 2) == 'H') {
            if (DoubleMetaphone.contains(string, n + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM")) {
                if (DoubleMetaphone.contains(string, n + 3, 2, "ER", "EN")) {
                    doubleMetaphone$DoubleMetaphoneResult.append("X", "SK");
                } else {
                    doubleMetaphone$DoubleMetaphoneResult.append("SK");
                }
            } else if (n == 0 && !this.isVowel(this.charAt(string, 3)) && this.charAt(string, 3) != 'W') {
                doubleMetaphone$DoubleMetaphoneResult.append('X', 'S');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('X');
            }
        } else if (DoubleMetaphone.contains(string, n + 2, 1, "I", "E", "Y")) {
            doubleMetaphone$DoubleMetaphoneResult.append('S');
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append("SK");
        }
        return n + 3;
    }

    private int handleT(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (DoubleMetaphone.contains(string, n, 4, "TION")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
            n += 3;
        } else if (DoubleMetaphone.contains(string, n, 3, "TIA", "TCH")) {
            doubleMetaphone$DoubleMetaphoneResult.append('X');
            n += 3;
        } else if (DoubleMetaphone.contains(string, n, 2, "TH") || DoubleMetaphone.contains(string, n, 3, "TTH")) {
            if (DoubleMetaphone.contains(string, n + 2, 2, "OM", "AM") || DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH")) {
                doubleMetaphone$DoubleMetaphoneResult.append('T');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('0', 'T');
            }
            n += 2;
        } else {
            doubleMetaphone$DoubleMetaphoneResult.append('T');
            n = DoubleMetaphone.contains(string, n + 1, 1, "T", "D") ? n + 2 : n + 1;
        }
        return n;
    }

    private int handleW(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (DoubleMetaphone.contains(string, n, 2, "WR")) {
            doubleMetaphone$DoubleMetaphoneResult.append('R');
            n += 2;
        } else if (n == 0 && (this.isVowel(this.charAt(string, n + 1)) || DoubleMetaphone.contains(string, n, 2, "WH"))) {
            if (this.isVowel(this.charAt(string, n + 1))) {
                doubleMetaphone$DoubleMetaphoneResult.append('A', 'F');
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('A');
            }
            ++n;
        } else if (n == string.length() - 1 && this.isVowel(this.charAt(string, n - 1)) || DoubleMetaphone.contains(string, n - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY") || DoubleMetaphone.contains(string, 0, 3, "SCH")) {
            doubleMetaphone$DoubleMetaphoneResult.appendAlternate('F');
            ++n;
        } else if (DoubleMetaphone.contains(string, n, 4, "WICZ", "WITZ")) {
            doubleMetaphone$DoubleMetaphoneResult.append("TS", "FX");
            n += 4;
        } else {
            ++n;
        }
        return n;
    }

    private int handleX(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n) {
        if (n == 0) {
            doubleMetaphone$DoubleMetaphoneResult.append('S');
            ++n;
        } else {
            if (n != string.length() - 1 || !DoubleMetaphone.contains(string, n - 3, 3, "IAU", "EAU") && !DoubleMetaphone.contains(string, n - 2, 2, "AU", "OU")) {
                doubleMetaphone$DoubleMetaphoneResult.append("KS");
            }
            n = DoubleMetaphone.contains(string, n + 1, 1, "C", "X") ? n + 2 : n + 1;
        }
        return n;
    }

    private int handleZ(String string, DoubleMetaphone$DoubleMetaphoneResult doubleMetaphone$DoubleMetaphoneResult, int n, boolean bl) {
        if (this.charAt(string, n + 1) == 'H') {
            doubleMetaphone$DoubleMetaphoneResult.append('J');
            n += 2;
        } else {
            if (DoubleMetaphone.contains(string, n + 1, 2, "ZO", "ZI", "ZA") || bl && n > 0 && this.charAt(string, n - 1) != 'T') {
                doubleMetaphone$DoubleMetaphoneResult.append("S", "TS");
            } else {
                doubleMetaphone$DoubleMetaphoneResult.append('S');
            }
            n = this.charAt(string, n + 1) == 'Z' ? n + 2 : n + 1;
        }
        return n;
    }

    private boolean conditionC0(String string, int n) {
        if (DoubleMetaphone.contains(string, n, 4, "CHIA")) {
            return true;
        }
        if (n <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(string, n - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(string, n - 1, 3, "ACH")) {
            return false;
        }
        char c2 = this.charAt(string, n + 2);
        return c2 != 'I' && c2 != 'E' || DoubleMetaphone.contains(string, n - 2, 6, "BACHER", "MACHER");
    }

    private boolean conditionCH0(String string, int n) {
        if (n != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(string, n + 1, 5, "HARAC", "HARIS") && !DoubleMetaphone.contains(string, n + 1, 3, "HOR", "HYM", "HIA", "HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(string, 0, 5, "CHORE");
    }

    private boolean conditionCH1(String string, int n) {
        return DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH") || DoubleMetaphone.contains(string, n - 2, 6, "ORCHES", "ARCHIT", "ORCHID") || DoubleMetaphone.contains(string, n + 2, 1, "T", "S") || (DoubleMetaphone.contains(string, n - 1, 1, "A", "O", "U", "E") || n == 0) && (DoubleMetaphone.contains(string, n + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || n + 1 == string.length() - 1);
    }

    private boolean conditionL0(String string, int n) {
        if (n == string.length() - 3 && DoubleMetaphone.contains(string, n - 1, 4, "ILLO", "ILLA", "ALLE")) {
            return true;
        }
        return (DoubleMetaphone.contains(string, string.length() - 2, 2, "AS", "OS") || DoubleMetaphone.contains(string, string.length() - 1, 1, "A", "O")) && DoubleMetaphone.contains(string, n - 1, 4, "ALLE");
    }

    private boolean conditionM0(String string, int n) {
        if (this.charAt(string, n + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(string, n - 1, 3, "UMB") && (n + 1 == string.length() - 1 || DoubleMetaphone.contains(string, n + 2, 2, "ER"));
    }

    private boolean isSlavoGermanic(String string) {
        return string.indexOf(87) > -1 || string.indexOf(75) > -1 || string.indexOf("CZ") > -1 || string.indexOf("WITZ") > -1;
    }

    private boolean isVowel(char c2) {
        return VOWELS.indexOf(c2) != -1;
    }

    private boolean isSilentStart(String string) {
        boolean bl = false;
        for (String string2 : SILENT_START) {
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String cleanInput(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string.toUpperCase(Locale.ENGLISH);
    }

    protected char charAt(String string, int n) {
        if (n < 0 || n >= string.length()) {
            return '\u0000';
        }
        return string.charAt(n);
    }

    protected static boolean contains(String string, int n, int n2, String ... stringArray) {
        boolean bl = false;
        if (n >= 0 && n + n2 <= string.length()) {
            String string2 = string.substring(n, n + n2);
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

